package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.ForwardedIPHeaderName
import scala.jdk.CollectionConverters._
final case class ForwardedIPConfig(
    headerName: ForwardedIPHeaderName,
    fallbackBehavior: zio.aws.wafv2.model.FallbackBehavior
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ForwardedIPConfig = {
    import ForwardedIPConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ForwardedIPConfig
      .builder()
      .headerName(ForwardedIPHeaderName.unwrap(headerName): java.lang.String)
      .fallbackBehavior(fallbackBehavior.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ForwardedIPConfig.ReadOnly =
    zio.aws.wafv2.model.ForwardedIPConfig.wrap(buildAwsValue())
}
object ForwardedIPConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ForwardedIPConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ForwardedIPConfig =
      zio.aws.wafv2.model.ForwardedIPConfig(headerName, fallbackBehavior)
    def headerName: ForwardedIPHeaderName
    def fallbackBehavior: zio.aws.wafv2.model.FallbackBehavior
    def getHeaderName: ZIO[Any, Nothing, ForwardedIPHeaderName] =
      ZIO.succeed(headerName)
    def getFallbackBehavior
        : ZIO[Any, Nothing, zio.aws.wafv2.model.FallbackBehavior] =
      ZIO.succeed(fallbackBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ForwardedIPConfig
  ) extends zio.aws.wafv2.model.ForwardedIPConfig.ReadOnly {
    override val headerName: ForwardedIPHeaderName =
      zio.aws.wafv2.model.primitives.ForwardedIPHeaderName(impl.headerName())
    override val fallbackBehavior: zio.aws.wafv2.model.FallbackBehavior =
      zio.aws.wafv2.model.FallbackBehavior.wrap(impl.fallbackBehavior())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ForwardedIPConfig
  ): zio.aws.wafv2.model.ForwardedIPConfig.ReadOnly = new Wrapper(impl)
}
