package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleAction(
    block: Optional[zio.aws.wafv2.model.BlockAction] = Optional.Absent,
    allow: Optional[zio.aws.wafv2.model.AllowAction] = Optional.Absent,
    count: Optional[zio.aws.wafv2.model.CountAction] = Optional.Absent,
    captcha: Optional[zio.aws.wafv2.model.CaptchaAction] = Optional.Absent,
    challenge: Optional[zio.aws.wafv2.model.ChallengeAction] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RuleAction = {
    import RuleAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RuleAction
      .builder()
      .optionallyWith(block.map(value => value.buildAwsValue()))(_.block)
      .optionallyWith(allow.map(value => value.buildAwsValue()))(_.allow)
      .optionallyWith(count.map(value => value.buildAwsValue()))(_.count)
      .optionallyWith(captcha.map(value => value.buildAwsValue()))(_.captcha)
      .optionallyWith(challenge.map(value => value.buildAwsValue()))(
        _.challenge
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RuleAction.ReadOnly =
    zio.aws.wafv2.model.RuleAction.wrap(buildAwsValue())
}
object RuleAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.RuleAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RuleAction =
      zio.aws.wafv2.model.RuleAction(
        block.map(value => value.asEditable),
        allow.map(value => value.asEditable),
        count.map(value => value.asEditable),
        captcha.map(value => value.asEditable),
        challenge.map(value => value.asEditable)
      )
    def block: Optional[zio.aws.wafv2.model.BlockAction.ReadOnly]
    def allow: Optional[zio.aws.wafv2.model.AllowAction.ReadOnly]
    def count: Optional[zio.aws.wafv2.model.CountAction.ReadOnly]
    def captcha: Optional[zio.aws.wafv2.model.CaptchaAction.ReadOnly]
    def challenge: Optional[zio.aws.wafv2.model.ChallengeAction.ReadOnly]
    def getBlock: ZIO[Any, AwsError, zio.aws.wafv2.model.BlockAction.ReadOnly] =
      AwsError.unwrapOptionField("block", block)
    def getAllow: ZIO[Any, AwsError, zio.aws.wafv2.model.AllowAction.ReadOnly] =
      AwsError.unwrapOptionField("allow", allow)
    def getCount: ZIO[Any, AwsError, zio.aws.wafv2.model.CountAction.ReadOnly] =
      AwsError.unwrapOptionField("count", count)
    def getCaptcha
        : ZIO[Any, AwsError, zio.aws.wafv2.model.CaptchaAction.ReadOnly] =
      AwsError.unwrapOptionField("captcha", captcha)
    def getChallenge
        : ZIO[Any, AwsError, zio.aws.wafv2.model.ChallengeAction.ReadOnly] =
      AwsError.unwrapOptionField("challenge", challenge)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RuleAction
  ) extends zio.aws.wafv2.model.RuleAction.ReadOnly {
    override val block: Optional[zio.aws.wafv2.model.BlockAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.block())
        .map(value => zio.aws.wafv2.model.BlockAction.wrap(value))
    override val allow: Optional[zio.aws.wafv2.model.AllowAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allow())
        .map(value => zio.aws.wafv2.model.AllowAction.wrap(value))
    override val count: Optional[zio.aws.wafv2.model.CountAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.count())
        .map(value => zio.aws.wafv2.model.CountAction.wrap(value))
    override val captcha: Optional[zio.aws.wafv2.model.CaptchaAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.captcha())
        .map(value => zio.aws.wafv2.model.CaptchaAction.wrap(value))
    override val challenge
        : Optional[zio.aws.wafv2.model.ChallengeAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.challenge())
        .map(value => zio.aws.wafv2.model.ChallengeAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RuleAction
  ): zio.aws.wafv2.model.RuleAction.ReadOnly = new Wrapper(impl)
}
