package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutLoggingConfigurationRequest(
    loggingConfiguration: zio.aws.wafv2.model.LoggingConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationRequest = {
    import PutLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationRequest
      .builder()
      .loggingConfiguration(loggingConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.PutLoggingConfigurationRequest.ReadOnly =
    zio.aws.wafv2.model.PutLoggingConfigurationRequest.wrap(buildAwsValue())
}
object PutLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.PutLoggingConfigurationRequest =
      zio.aws.wafv2.model
        .PutLoggingConfigurationRequest(loggingConfiguration.asEditable)
    def loggingConfiguration: zio.aws.wafv2.model.LoggingConfiguration.ReadOnly
    def getLoggingConfiguration
        : ZIO[Any, Nothing, zio.aws.wafv2.model.LoggingConfiguration.ReadOnly] =
      ZIO.succeed(loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationRequest
  ) extends zio.aws.wafv2.model.PutLoggingConfigurationRequest.ReadOnly {
    override val loggingConfiguration
        : zio.aws.wafv2.model.LoggingConfiguration.ReadOnly =
      zio.aws.wafv2.model.LoggingConfiguration.wrap(impl.loggingConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationRequest
  ): zio.aws.wafv2.model.PutLoggingConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
