package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListAvailableManagedRuleGroupsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    managedRuleGroups: Optional[
      Iterable[zio.aws.wafv2.model.ManagedRuleGroupSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsResponse = {
    import ListAvailableManagedRuleGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        managedRuleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedRuleGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.ListAvailableManagedRuleGroupsResponse.ReadOnly =
    zio.aws.wafv2.model.ListAvailableManagedRuleGroupsResponse
      .wrap(buildAwsValue())
}
object ListAvailableManagedRuleGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListAvailableManagedRuleGroupsResponse =
      zio.aws.wafv2.model.ListAvailableManagedRuleGroupsResponse(
        nextMarker.map(value => value),
        managedRuleGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def managedRuleGroups
        : Optional[List[zio.aws.wafv2.model.ManagedRuleGroupSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getManagedRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.ManagedRuleGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("managedRuleGroups", managedRuleGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsResponse
  ) extends zio.aws.wafv2.model.ListAvailableManagedRuleGroupsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val managedRuleGroups
        : Optional[List[zio.aws.wafv2.model.ManagedRuleGroupSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedRuleGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.ManagedRuleGroupSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsResponse
  ): zio.aws.wafv2.model.ListAvailableManagedRuleGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
