package zio.aws.wafv2.model
import scala.jdk.CollectionConverters._
sealed trait Platform {
  def unwrap: software.amazon.awssdk.services.wafv2.model.Platform
}
object Platform {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.Platform
  ): zio.aws.wafv2.model.Platform = value match {
    case software.amazon.awssdk.services.wafv2.model.Platform.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.Platform.IOS =>
      val r = IOS
      r
    case software.amazon.awssdk.services.wafv2.model.Platform.ANDROID =>
      val r = ANDROID
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.Platform {
    override def unwrap: software.amazon.awssdk.services.wafv2.model.Platform =
      software.amazon.awssdk.services.wafv2.model.Platform.UNKNOWN_TO_SDK_VERSION
  }
  case object IOS extends zio.aws.wafv2.model.Platform {
    override def unwrap: software.amazon.awssdk.services.wafv2.model.Platform =
      software.amazon.awssdk.services.wafv2.model.Platform.IOS
  }
  case object ANDROID extends zio.aws.wafv2.model.Platform {
    override def unwrap: software.amazon.awssdk.services.wafv2.model.Platform =
      software.amazon.awssdk.services.wafv2.model.Platform.ANDROID
  }
}
