package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class DeleteLoggingConfigurationRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationRequest = {
    import DeleteLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.DeleteLoggingConfigurationRequest.ReadOnly =
    zio.aws.wafv2.model.DeleteLoggingConfigurationRequest.wrap(buildAwsValue())
}
object DeleteLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.DeleteLoggingConfigurationRequest =
      zio.aws.wafv2.model.DeleteLoggingConfigurationRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationRequest
  ) extends zio.aws.wafv2.model.DeleteLoggingConfigurationRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationRequest
  ): zio.aws.wafv2.model.DeleteLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
