package zio.aws.wafv2.model
import scala.jdk.CollectionConverters._
sealed trait ActionValue {
  def unwrap: software.amazon.awssdk.services.wafv2.model.ActionValue
}
object ActionValue {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.ActionValue
  ): zio.aws.wafv2.model.ActionValue = value match {
    case software.amazon.awssdk.services.wafv2.model.ActionValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.ActionValue.ALLOW =>
      val r = ALLOW
      r
    case software.amazon.awssdk.services.wafv2.model.ActionValue.BLOCK =>
      val r = BLOCK
      r
    case software.amazon.awssdk.services.wafv2.model.ActionValue.COUNT =>
      val r = COUNT
      r
    case software.amazon.awssdk.services.wafv2.model.ActionValue.CAPTCHA =>
      val r = CAPTCHA
      r
    case software.amazon.awssdk.services.wafv2.model.ActionValue.EXCLUDED_AS_COUNT =>
      val r = EXCLUDED_AS_COUNT
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.ActionValue {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ActionValue =
      software.amazon.awssdk.services.wafv2.model.ActionValue.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOW extends zio.aws.wafv2.model.ActionValue {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ActionValue =
      software.amazon.awssdk.services.wafv2.model.ActionValue.ALLOW
  }
  case object BLOCK extends zio.aws.wafv2.model.ActionValue {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ActionValue =
      software.amazon.awssdk.services.wafv2.model.ActionValue.BLOCK
  }
  case object COUNT extends zio.aws.wafv2.model.ActionValue {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ActionValue =
      software.amazon.awssdk.services.wafv2.model.ActionValue.COUNT
  }
  case object CAPTCHA extends zio.aws.wafv2.model.ActionValue {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ActionValue =
      software.amazon.awssdk.services.wafv2.model.ActionValue.CAPTCHA
  }
  case object EXCLUDED_AS_COUNT extends zio.aws.wafv2.model.ActionValue {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ActionValue =
      software.amazon.awssdk.services.wafv2.model.ActionValue.EXCLUDED_AS_COUNT
  }
}
