package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListLoggingConfigurationsResponse(
    loggingConfigurations: Optional[
      Iterable[zio.aws.wafv2.model.LoggingConfiguration]
    ] = Optional.Absent,
    nextMarker: Optional[NextMarker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse = {
    import ListLoggingConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse
      .builder()
      .optionallyWith(
        loggingConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loggingConfigurations)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.ListLoggingConfigurationsResponse.ReadOnly =
    zio.aws.wafv2.model.ListLoggingConfigurationsResponse.wrap(buildAwsValue())
}
object ListLoggingConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListLoggingConfigurationsResponse =
      zio.aws.wafv2.model.ListLoggingConfigurationsResponse(
        loggingConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def loggingConfigurations
        : Optional[List[zio.aws.wafv2.model.LoggingConfiguration.ReadOnly]]
    def nextMarker: Optional[NextMarker]
    def getLoggingConfigurations: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.LoggingConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("loggingConfigurations", loggingConfigurations)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse
  ) extends zio.aws.wafv2.model.ListLoggingConfigurationsResponse.ReadOnly {
    override val loggingConfigurations
        : Optional[List[zio.aws.wafv2.model.LoggingConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.LoggingConfiguration.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse
  ): zio.aws.wafv2.model.ListLoggingConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
