package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class GetWebAclForResourceRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceRequest = {
    import GetWebAclForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetWebAclForResourceRequest.ReadOnly =
    zio.aws.wafv2.model.GetWebAclForResourceRequest.wrap(buildAwsValue())
}
object GetWebAclForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetWebAclForResourceRequest =
      zio.aws.wafv2.model.GetWebAclForResourceRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceRequest
  ) extends zio.aws.wafv2.model.GetWebAclForResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceRequest
  ): zio.aws.wafv2.model.GetWebAclForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
