package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  LabelName,
  CapacityUnit,
  ResourceArn,
  VersionKeyString
}
import scala.jdk.CollectionConverters._
final case class DescribeManagedRuleGroupResponse(
    versionName: Optional[VersionKeyString] = Optional.Absent,
    snsTopicArn: Optional[ResourceArn] = Optional.Absent,
    capacity: Optional[CapacityUnit] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.wafv2.model.RuleSummary]] =
      Optional.Absent,
    labelNamespace: Optional[LabelName] = Optional.Absent,
    availableLabels: Optional[Iterable[zio.aws.wafv2.model.LabelSummary]] =
      Optional.Absent,
    consumedLabels: Optional[Iterable[zio.aws.wafv2.model.LabelSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse = {
    import DescribeManagedRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse
      .builder()
      .optionallyWith(
        versionName.map(value =>
          VersionKeyString.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(
        snsTopicArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        capacity.map(value => CapacityUnit.unwrap(value): java.lang.Long)
      )(_.capacity)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(
        labelNamespace.map(value => LabelName.unwrap(value): java.lang.String)
      )(_.labelNamespace)
      .optionallyWith(
        availableLabels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availableLabels)
      .optionallyWith(
        consumedLabels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumedLabels)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.ReadOnly =
    zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.wrap(buildAwsValue())
}
object DescribeManagedRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.DescribeManagedRuleGroupResponse =
      zio.aws.wafv2.model.DescribeManagedRuleGroupResponse(
        versionName.map(value => value),
        snsTopicArn.map(value => value),
        capacity.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        labelNamespace.map(value => value),
        availableLabels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        consumedLabels.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def versionName: Optional[VersionKeyString]
    def snsTopicArn: Optional[ResourceArn]
    def capacity: Optional[CapacityUnit]
    def rules: Optional[List[zio.aws.wafv2.model.RuleSummary.ReadOnly]]
    def labelNamespace: Optional[LabelName]
    def availableLabels
        : Optional[List[zio.aws.wafv2.model.LabelSummary.ReadOnly]]
    def consumedLabels
        : Optional[List[zio.aws.wafv2.model.LabelSummary.ReadOnly]]
    def getVersionName: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getSnsTopicArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getCapacity: ZIO[Any, AwsError, CapacityUnit] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.RuleSummary.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getLabelNamespace: ZIO[Any, AwsError, LabelName] =
      AwsError.unwrapOptionField("labelNamespace", labelNamespace)
    def getAvailableLabels
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.LabelSummary.ReadOnly]] =
      AwsError.unwrapOptionField("availableLabels", availableLabels)
    def getConsumedLabels
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.LabelSummary.ReadOnly]] =
      AwsError.unwrapOptionField("consumedLabels", consumedLabels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse
  ) extends zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.ReadOnly {
    override val versionName: Optional[VersionKeyString] = zio.aws.core.internal
      .optionalFromNullable(impl.versionName())
      .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
    override val snsTopicArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => zio.aws.wafv2.model.primitives.ResourceArn(value))
    override val capacity: Optional[CapacityUnit] = zio.aws.core.internal
      .optionalFromNullable(impl.capacity())
      .map(value => zio.aws.wafv2.model.primitives.CapacityUnit(value))
    override val rules
        : Optional[List[zio.aws.wafv2.model.RuleSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.RuleSummary.wrap(item)
          }.toList
        )
    override val labelNamespace: Optional[LabelName] = zio.aws.core.internal
      .optionalFromNullable(impl.labelNamespace())
      .map(value => zio.aws.wafv2.model.primitives.LabelName(value))
    override val availableLabels
        : Optional[List[zio.aws.wafv2.model.LabelSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableLabels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.LabelSummary.wrap(item)
          }.toList
        )
    override val consumedLabels
        : Optional[List[zio.aws.wafv2.model.LabelSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumedLabels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.LabelSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse
  ): zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.ReadOnly =
    new Wrapper(impl)
}
