package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.{
  CustomHTTPHeaderValue,
  CustomHTTPHeaderName
}
import scala.jdk.CollectionConverters._
final case class CustomHTTPHeader(
    name: CustomHTTPHeaderName,
    value: CustomHTTPHeaderValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CustomHTTPHeader = {
    import CustomHTTPHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CustomHTTPHeader
      .builder()
      .name(CustomHTTPHeaderName.unwrap(name): java.lang.String)
      .value(CustomHTTPHeaderValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CustomHTTPHeader.ReadOnly =
    zio.aws.wafv2.model.CustomHTTPHeader.wrap(buildAwsValue())
}
object CustomHTTPHeader {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CustomHTTPHeader
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CustomHTTPHeader =
      zio.aws.wafv2.model.CustomHTTPHeader(name, value)
    def name: CustomHTTPHeaderName
    def value: CustomHTTPHeaderValue
    def getName: ZIO[Any, Nothing, CustomHTTPHeaderName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, CustomHTTPHeaderValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CustomHTTPHeader
  ) extends zio.aws.wafv2.model.CustomHTTPHeader.ReadOnly {
    override val name: CustomHTTPHeaderName =
      zio.aws.wafv2.model.primitives.CustomHTTPHeaderName(impl.name())
    override val value: CustomHTTPHeaderValue =
      zio.aws.wafv2.model.primitives.CustomHTTPHeaderValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CustomHTTPHeader
  ): zio.aws.wafv2.model.CustomHTTPHeader.ReadOnly = new Wrapper(impl)
}
