package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetWebAclForResourceResponse(
    webACL: Optional[zio.aws.wafv2.model.WebACL] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceResponse = {
    import GetWebAclForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceResponse
      .builder()
      .optionallyWith(webACL.map(value => value.buildAwsValue()))(_.webACL)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetWebAclForResourceResponse.ReadOnly =
    zio.aws.wafv2.model.GetWebAclForResourceResponse.wrap(buildAwsValue())
}
object GetWebAclForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetWebAclForResourceResponse =
      zio.aws.wafv2.model
        .GetWebAclForResourceResponse(webACL.map(value => value.asEditable))
    def webACL: Optional[zio.aws.wafv2.model.WebACL.ReadOnly]
    def getWebACL: ZIO[Any, AwsError, zio.aws.wafv2.model.WebACL.ReadOnly] =
      AwsError.unwrapOptionField("webACL", webACL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceResponse
  ) extends zio.aws.wafv2.model.GetWebAclForResourceResponse.ReadOnly {
    override val webACL: Optional[zio.aws.wafv2.model.WebACL.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webACL())
        .map(value => zio.aws.wafv2.model.WebACL.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceResponse
  ): zio.aws.wafv2.model.GetWebAclForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
