package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateRegexPatternSetResponse(
    summary: Optional[zio.aws.wafv2.model.RegexPatternSetSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetResponse = {
    import CreateRegexPatternSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetResponse
      .builder()
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CreateRegexPatternSetResponse.ReadOnly =
    zio.aws.wafv2.model.CreateRegexPatternSetResponse.wrap(buildAwsValue())
}
object CreateRegexPatternSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CreateRegexPatternSetResponse =
      zio.aws.wafv2.model
        .CreateRegexPatternSetResponse(summary.map(value => value.asEditable))
    def summary: Optional[zio.aws.wafv2.model.RegexPatternSetSummary.ReadOnly]
    def getSummary: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.RegexPatternSetSummary.ReadOnly
    ] = AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetResponse
  ) extends zio.aws.wafv2.model.CreateRegexPatternSetResponse.ReadOnly {
    override val summary
        : Optional[zio.aws.wafv2.model.RegexPatternSetSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summary())
        .map(value => zio.aws.wafv2.model.RegexPatternSetSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetResponse
  ): zio.aws.wafv2.model.CreateRegexPatternSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
