package zio.aws.wafv2.model
import zio.aws.wafv2.model.primitives.{RulePriority, EntityName}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Rule(
    name: EntityName,
    priority: RulePriority,
    statement: zio.aws.wafv2.model.Statement,
    action: Optional[zio.aws.wafv2.model.RuleAction] = Optional.Absent,
    overrideAction: Optional[zio.aws.wafv2.model.OverrideAction] =
      Optional.Absent,
    ruleLabels: Optional[Iterable[zio.aws.wafv2.model.Label]] = Optional.Absent,
    visibilityConfig: zio.aws.wafv2.model.VisibilityConfig,
    captchaConfig: Optional[zio.aws.wafv2.model.CaptchaConfig] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.Rule
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .priority(RulePriority.unwrap(priority): Integer)
      .statement(statement.buildAwsValue())
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(overrideAction.map(value => value.buildAwsValue()))(
        _.overrideAction
      )
      .optionallyWith(
        ruleLabels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleLabels)
      .visibilityConfig(visibilityConfig.buildAwsValue())
      .optionallyWith(captchaConfig.map(value => value.buildAwsValue()))(
        _.captchaConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.Rule.ReadOnly =
    zio.aws.wafv2.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.Rule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.Rule = zio.aws.wafv2.model.Rule(
      name,
      priority,
      statement.asEditable,
      action.map(value => value.asEditable),
      overrideAction.map(value => value.asEditable),
      ruleLabels.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      visibilityConfig.asEditable,
      captchaConfig.map(value => value.asEditable)
    )
    def name: EntityName
    def priority: RulePriority
    def statement: zio.aws.wafv2.model.Statement.ReadOnly
    def action: Optional[zio.aws.wafv2.model.RuleAction.ReadOnly]
    def overrideAction: Optional[zio.aws.wafv2.model.OverrideAction.ReadOnly]
    def ruleLabels: Optional[List[zio.aws.wafv2.model.Label.ReadOnly]]
    def visibilityConfig: zio.aws.wafv2.model.VisibilityConfig.ReadOnly
    def captchaConfig: Optional[zio.aws.wafv2.model.CaptchaConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getPriority: ZIO[Any, Nothing, RulePriority] = ZIO.succeed(priority)
    def getStatement
        : ZIO[Any, Nothing, zio.aws.wafv2.model.Statement.ReadOnly] =
      ZIO.succeed(statement)
    def getAction: ZIO[Any, AwsError, zio.aws.wafv2.model.RuleAction.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getOverrideAction
        : ZIO[Any, AwsError, zio.aws.wafv2.model.OverrideAction.ReadOnly] =
      AwsError.unwrapOptionField("overrideAction", overrideAction)
    def getRuleLabels
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.Label.ReadOnly]] =
      AwsError.unwrapOptionField("ruleLabels", ruleLabels)
    def getVisibilityConfig
        : ZIO[Any, Nothing, zio.aws.wafv2.model.VisibilityConfig.ReadOnly] =
      ZIO.succeed(visibilityConfig)
    def getCaptchaConfig
        : ZIO[Any, AwsError, zio.aws.wafv2.model.CaptchaConfig.ReadOnly] =
      AwsError.unwrapOptionField("captchaConfig", captchaConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.Rule
  ) extends zio.aws.wafv2.model.Rule.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val priority: RulePriority =
      zio.aws.wafv2.model.primitives.RulePriority(impl.priority())
    override val statement: zio.aws.wafv2.model.Statement.ReadOnly =
      zio.aws.wafv2.model.Statement.wrap(impl.statement())
    override val action: Optional[zio.aws.wafv2.model.RuleAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.wafv2.model.RuleAction.wrap(value))
    override val overrideAction
        : Optional[zio.aws.wafv2.model.OverrideAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrideAction())
        .map(value => zio.aws.wafv2.model.OverrideAction.wrap(value))
    override val ruleLabels
        : Optional[List[zio.aws.wafv2.model.Label.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleLabels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.Label.wrap(item)
          }.toList
        )
    override val visibilityConfig
        : zio.aws.wafv2.model.VisibilityConfig.ReadOnly =
      zio.aws.wafv2.model.VisibilityConfig.wrap(impl.visibilityConfig())
    override val captchaConfig
        : Optional[zio.aws.wafv2.model.CaptchaConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.captchaConfig())
        .map(value => zio.aws.wafv2.model.CaptchaConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.Rule
  ): zio.aws.wafv2.model.Rule.ReadOnly = new Wrapper(impl)
}
