package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListRegexPatternSetsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    regexPatternSets: Optional[
      Iterable[zio.aws.wafv2.model.RegexPatternSetSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsResponse = {
    import ListRegexPatternSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        regexPatternSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regexPatternSets)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListRegexPatternSetsResponse.ReadOnly =
    zio.aws.wafv2.model.ListRegexPatternSetsResponse.wrap(buildAwsValue())
}
object ListRegexPatternSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListRegexPatternSetsResponse =
      zio.aws.wafv2.model.ListRegexPatternSetsResponse(
        nextMarker.map(value => value),
        regexPatternSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def regexPatternSets
        : Optional[List[zio.aws.wafv2.model.RegexPatternSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getRegexPatternSets: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.RegexPatternSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("regexPatternSets", regexPatternSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsResponse
  ) extends zio.aws.wafv2.model.ListRegexPatternSetsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val regexPatternSets
        : Optional[List[zio.aws.wafv2.model.RegexPatternSetSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regexPatternSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.RegexPatternSetSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsResponse
  ): zio.aws.wafv2.model.ListRegexPatternSetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
