package zio.aws.wafv2.model
import zio.aws.wafv2.model.primitives.{Timestamp, VersionKeyString}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ManagedRuleGroupVersion(
    name: Optional[VersionKeyString] = Optional.Absent,
    lastUpdateTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupVersion = {
    import ManagedRuleGroupVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupVersion
      .builder()
      .optionallyWith(
        name.map(value => VersionKeyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        lastUpdateTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ManagedRuleGroupVersion.ReadOnly =
    zio.aws.wafv2.model.ManagedRuleGroupVersion.wrap(buildAwsValue())
}
object ManagedRuleGroupVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ManagedRuleGroupVersion =
      zio.aws.wafv2.model.ManagedRuleGroupVersion(
        name.map(value => value),
        lastUpdateTimestamp.map(value => value)
      )
    def name: Optional[VersionKeyString]
    def lastUpdateTimestamp: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("name", name)
    def getLastUpdateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTimestamp", lastUpdateTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupVersion
  ) extends zio.aws.wafv2.model.ManagedRuleGroupVersion.ReadOnly {
    override val name: Optional[VersionKeyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
    override val lastUpdateTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateTimestamp())
        .map(value => zio.aws.wafv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupVersion
  ): zio.aws.wafv2.model.ManagedRuleGroupVersion.ReadOnly = new Wrapper(impl)
}
