package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{OutputUrl, LockToken}
import scala.jdk.CollectionConverters._
final case class GetWebAclResponse(
    webACL: Optional[zio.aws.wafv2.model.WebACL] = Optional.Absent,
    lockToken: Optional[LockToken] = Optional.Absent,
    applicationIntegrationURL: Optional[OutputUrl] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetWebAclResponse = {
    import GetWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetWebAclResponse
      .builder()
      .optionallyWith(webACL.map(value => value.buildAwsValue()))(_.webACL)
      .optionallyWith(
        lockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.lockToken)
      .optionallyWith(
        applicationIntegrationURL.map(value =>
          OutputUrl.unwrap(value): java.lang.String
        )
      )(_.applicationIntegrationURL)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetWebAclResponse.ReadOnly =
    zio.aws.wafv2.model.GetWebAclResponse.wrap(buildAwsValue())
}
object GetWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetWebAclResponse =
      zio.aws.wafv2.model.GetWebAclResponse(
        webACL.map(value => value.asEditable),
        lockToken.map(value => value),
        applicationIntegrationURL.map(value => value)
      )
    def webACL: Optional[zio.aws.wafv2.model.WebACL.ReadOnly]
    def lockToken: Optional[LockToken]
    def applicationIntegrationURL: Optional[OutputUrl]
    def getWebACL: ZIO[Any, AwsError, zio.aws.wafv2.model.WebACL.ReadOnly] =
      AwsError.unwrapOptionField("webACL", webACL)
    def getLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("lockToken", lockToken)
    def getApplicationIntegrationURL: ZIO[Any, AwsError, OutputUrl] = AwsError
      .unwrapOptionField("applicationIntegrationURL", applicationIntegrationURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetWebAclResponse
  ) extends zio.aws.wafv2.model.GetWebAclResponse.ReadOnly {
    override val webACL: Optional[zio.aws.wafv2.model.WebACL.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webACL())
        .map(value => zio.aws.wafv2.model.WebACL.wrap(value))
    override val lockToken: Optional[LockToken] = zio.aws.core.internal
      .optionalFromNullable(impl.lockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
    override val applicationIntegrationURL: Optional[OutputUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationIntegrationURL())
        .map(value => zio.aws.wafv2.model.primitives.OutputUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetWebAclResponse
  ): zio.aws.wafv2.model.GetWebAclResponse.ReadOnly = new Wrapper(impl)
}
