package zio.aws.wafv2.model
import zio.aws.wafv2.model.primitives.{EntityName, ResponseStatusCode}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CustomResponse(
    responseCode: ResponseStatusCode,
    customResponseBodyKey: Optional[EntityName] = Optional.Absent,
    responseHeaders: Optional[Iterable[zio.aws.wafv2.model.CustomHTTPHeader]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CustomResponse = {
    import CustomResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CustomResponse
      .builder()
      .responseCode(ResponseStatusCode.unwrap(responseCode): Integer)
      .optionallyWith(
        customResponseBodyKey.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.customResponseBodyKey)
      .optionallyWith(
        responseHeaders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responseHeaders)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CustomResponse.ReadOnly =
    zio.aws.wafv2.model.CustomResponse.wrap(buildAwsValue())
}
object CustomResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CustomResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CustomResponse =
      zio.aws.wafv2.model.CustomResponse(
        responseCode,
        customResponseBodyKey.map(value => value),
        responseHeaders.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def responseCode: ResponseStatusCode
    def customResponseBodyKey: Optional[EntityName]
    def responseHeaders
        : Optional[List[zio.aws.wafv2.model.CustomHTTPHeader.ReadOnly]]
    def getResponseCode: ZIO[Any, Nothing, ResponseStatusCode] =
      ZIO.succeed(responseCode)
    def getCustomResponseBodyKey: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("customResponseBodyKey", customResponseBodyKey)
    def getResponseHeaders: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.CustomHTTPHeader.ReadOnly
    ]] = AwsError.unwrapOptionField("responseHeaders", responseHeaders)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CustomResponse
  ) extends zio.aws.wafv2.model.CustomResponse.ReadOnly {
    override val responseCode: ResponseStatusCode =
      zio.aws.wafv2.model.primitives.ResponseStatusCode(impl.responseCode())
    override val customResponseBodyKey: Optional[EntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customResponseBodyKey())
        .map(value => zio.aws.wafv2.model.primitives.EntityName(value))
    override val responseHeaders
        : Optional[List[zio.aws.wafv2.model.CustomHTTPHeader.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseHeaders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.CustomHTTPHeader.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CustomResponse
  ): zio.aws.wafv2.model.CustomResponse.ReadOnly = new Wrapper(impl)
}
