package zio.aws.wafv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.TextTransformationPriority
import scala.jdk.CollectionConverters._
final case class TextTransformation(
    priority: TextTransformationPriority,
    `type`: zio.aws.wafv2.model.TextTransformationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.TextTransformation = {
    import TextTransformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.TextTransformation
      .builder()
      .priority(TextTransformationPriority.unwrap(priority): Integer)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.TextTransformation.ReadOnly =
    zio.aws.wafv2.model.TextTransformation.wrap(buildAwsValue())
}
object TextTransformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.TextTransformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.TextTransformation =
      zio.aws.wafv2.model.TextTransformation(priority, `type`)
    def priority: TextTransformationPriority
    def `type`: zio.aws.wafv2.model.TextTransformationType
    def getPriority: ZIO[Any, Nothing, TextTransformationPriority] =
      ZIO.succeed(priority)
    def getType: ZIO[Any, Nothing, zio.aws.wafv2.model.TextTransformationType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.TextTransformation
  ) extends zio.aws.wafv2.model.TextTransformation.ReadOnly {
    override val priority: TextTransformationPriority =
      zio.aws.wafv2.model.primitives.TextTransformationPriority(impl.priority())
    override val `type`: zio.aws.wafv2.model.TextTransformationType =
      zio.aws.wafv2.model.TextTransformationType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.TextTransformation
  ): zio.aws.wafv2.model.TextTransformation.ReadOnly = new Wrapper(impl)
}
