package zio.aws.wafv2.model
import scala.jdk.CollectionConverters._
sealed trait OversizeHandling {
  def unwrap: software.amazon.awssdk.services.wafv2.model.OversizeHandling
}
object OversizeHandling {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.OversizeHandling
  ): zio.aws.wafv2.model.OversizeHandling = value match {
    case software.amazon.awssdk.services.wafv2.model.OversizeHandling.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.OversizeHandling.CONTINUE =>
      val r = CONTINUE
      r
    case software.amazon.awssdk.services.wafv2.model.OversizeHandling.MATCH =>
      val r = MATCH
      r
    case software.amazon.awssdk.services.wafv2.model.OversizeHandling.NO_MATCH =>
      val r = NO_MATCH
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.OversizeHandling {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.OversizeHandling =
      software.amazon.awssdk.services.wafv2.model.OversizeHandling.UNKNOWN_TO_SDK_VERSION
  }
  case object CONTINUE extends zio.aws.wafv2.model.OversizeHandling {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.OversizeHandling =
      software.amazon.awssdk.services.wafv2.model.OversizeHandling.CONTINUE
  }
  case object MATCH extends zio.aws.wafv2.model.OversizeHandling {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.OversizeHandling =
      software.amazon.awssdk.services.wafv2.model.OversizeHandling.MATCH
  }
  case object NO_MATCH extends zio.aws.wafv2.model.OversizeHandling {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.OversizeHandling =
      software.amazon.awssdk.services.wafv2.model.OversizeHandling.NO_MATCH
  }
}
