package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListRuleGroupsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    ruleGroups: Optional[Iterable[zio.aws.wafv2.model.RuleGroupSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListRuleGroupsResponse = {
    import ListRuleGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListRuleGroupsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        ruleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleGroups)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListRuleGroupsResponse.ReadOnly =
    zio.aws.wafv2.model.ListRuleGroupsResponse.wrap(buildAwsValue())
}
object ListRuleGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListRuleGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListRuleGroupsResponse =
      zio.aws.wafv2.model.ListRuleGroupsResponse(
        nextMarker.map(value => value),
        ruleGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def ruleGroups
        : Optional[List[zio.aws.wafv2.model.RuleGroupSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.RuleGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("ruleGroups", ruleGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListRuleGroupsResponse
  ) extends zio.aws.wafv2.model.ListRuleGroupsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val ruleGroups
        : Optional[List[zio.aws.wafv2.model.RuleGroupSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.RuleGroupSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListRuleGroupsResponse
  ): zio.aws.wafv2.model.ListRuleGroupsResponse.ReadOnly = new Wrapper(impl)
}
