package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.SingleCookieName
import scala.jdk.CollectionConverters._
final case class CookieMatchPattern(
    all: Optional[zio.aws.wafv2.model.All] = Optional.Absent,
    includedCookies: Optional[Iterable[SingleCookieName]] = Optional.Absent,
    excludedCookies: Optional[Iterable[SingleCookieName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CookieMatchPattern = {
    import CookieMatchPattern.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CookieMatchPattern
      .builder()
      .optionallyWith(all.map(value => value.buildAwsValue()))(_.all)
      .optionallyWith(
        includedCookies.map(value =>
          value.map { item =>
            SingleCookieName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.includedCookies)
      .optionallyWith(
        excludedCookies.map(value =>
          value.map { item =>
            SingleCookieName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludedCookies)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CookieMatchPattern.ReadOnly =
    zio.aws.wafv2.model.CookieMatchPattern.wrap(buildAwsValue())
}
object CookieMatchPattern {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CookieMatchPattern
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CookieMatchPattern =
      zio.aws.wafv2.model.CookieMatchPattern(
        all.map(value => value.asEditable),
        includedCookies.map(value => value),
        excludedCookies.map(value => value)
      )
    def all: Optional[zio.aws.wafv2.model.All.ReadOnly]
    def includedCookies: Optional[List[SingleCookieName]]
    def excludedCookies: Optional[List[SingleCookieName]]
    def getAll: ZIO[Any, AwsError, zio.aws.wafv2.model.All.ReadOnly] =
      AwsError.unwrapOptionField("all", all)
    def getIncludedCookies: ZIO[Any, AwsError, List[SingleCookieName]] =
      AwsError.unwrapOptionField("includedCookies", includedCookies)
    def getExcludedCookies: ZIO[Any, AwsError, List[SingleCookieName]] =
      AwsError.unwrapOptionField("excludedCookies", excludedCookies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CookieMatchPattern
  ) extends zio.aws.wafv2.model.CookieMatchPattern.ReadOnly {
    override val all: Optional[zio.aws.wafv2.model.All.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.all())
        .map(value => zio.aws.wafv2.model.All.wrap(value))
    override val includedCookies: Optional[List[SingleCookieName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includedCookies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.primitives.SingleCookieName(item)
          }.toList
        )
    override val excludedCookies: Optional[List[SingleCookieName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludedCookies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.primitives.SingleCookieName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CookieMatchPattern
  ): zio.aws.wafv2.model.CookieMatchPattern.ReadOnly = new Wrapper(impl)
}
