package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  LockToken,
  EntityDescription,
  EntityId,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class UpdateRuleGroupRequest(
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    id: EntityId,
    description: Optional[EntityDescription] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.wafv2.model.Rule]] = Optional.Absent,
    visibilityConfig: zio.aws.wafv2.model.VisibilityConfig,
    lockToken: LockToken,
    customResponseBodies: Optional[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupRequest = {
    import UpdateRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupRequest
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .id(EntityId.unwrap(id): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .visibilityConfig(visibilityConfig.buildAwsValue())
      .lockToken(LockToken.unwrap(lockToken): java.lang.String)
      .optionallyWith(
        customResponseBodies.map(value =>
          value
            .map({ case (key, value) =>
              (EntityName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.customResponseBodies)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.UpdateRuleGroupRequest.ReadOnly =
    zio.aws.wafv2.model.UpdateRuleGroupRequest.wrap(buildAwsValue())
}
object UpdateRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.UpdateRuleGroupRequest =
      zio.aws.wafv2.model.UpdateRuleGroupRequest(
        name,
        scope,
        id,
        description.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        visibilityConfig.asEditable,
        lockToken,
        customResponseBodies.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def id: EntityId
    def description: Optional[EntityDescription]
    def rules: Optional[List[zio.aws.wafv2.model.Rule.ReadOnly]]
    def visibilityConfig: zio.aws.wafv2.model.VisibilityConfig.ReadOnly
    def lockToken: LockToken
    def customResponseBodies: Optional[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(id)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRules: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getVisibilityConfig
        : ZIO[Any, Nothing, zio.aws.wafv2.model.VisibilityConfig.ReadOnly] =
      ZIO.succeed(visibilityConfig)
    def getLockToken: ZIO[Any, Nothing, LockToken] = ZIO.succeed(lockToken)
    def getCustomResponseBodies: ZIO[Any, AwsError, Map[
      EntityName,
      zio.aws.wafv2.model.CustomResponseBody.ReadOnly
    ]] =
      AwsError.unwrapOptionField("customResponseBodies", customResponseBodies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupRequest
  ) extends zio.aws.wafv2.model.UpdateRuleGroupRequest.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val id: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.id())
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val rules: Optional[List[zio.aws.wafv2.model.Rule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.Rule.wrap(item)
          }.toList
        )
    override val visibilityConfig
        : zio.aws.wafv2.model.VisibilityConfig.ReadOnly =
      zio.aws.wafv2.model.VisibilityConfig.wrap(impl.visibilityConfig())
    override val lockToken: LockToken =
      zio.aws.wafv2.model.primitives.LockToken(impl.lockToken())
    override val customResponseBodies: Optional[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customResponseBodies())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wafv2.model.primitives.EntityName(
              key
            ) -> zio.aws.wafv2.model.CustomResponseBody.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupRequest
  ): zio.aws.wafv2.model.UpdateRuleGroupRequest.ReadOnly = new Wrapper(impl)
}
