package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.RegexPatternString
import scala.jdk.CollectionConverters._
final case class Regex(
    regexString: Optional[RegexPatternString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.Regex = {
    import Regex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.Regex
      .builder()
      .optionallyWith(
        regexString.map(value =>
          RegexPatternString.unwrap(value): java.lang.String
        )
      )(_.regexString)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.Regex.ReadOnly =
    zio.aws.wafv2.model.Regex.wrap(buildAwsValue())
}
object Regex {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.Regex] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.Regex =
      zio.aws.wafv2.model.Regex(regexString.map(value => value))
    def regexString: Optional[RegexPatternString]
    def getRegexString: ZIO[Any, AwsError, RegexPatternString] =
      AwsError.unwrapOptionField("regexString", regexString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.Regex
  ) extends zio.aws.wafv2.model.Regex.ReadOnly {
    override val regexString: Optional[RegexPatternString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regexString())
        .map(value => zio.aws.wafv2.model.primitives.RegexPatternString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.Regex
  ): zio.aws.wafv2.model.Regex.ReadOnly = new Wrapper(impl)
}
