package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JsonBody(
    matchPattern: zio.aws.wafv2.model.JsonMatchPattern,
    matchScope: zio.aws.wafv2.model.JsonMatchScope,
    invalidFallbackBehavior: Optional[
      zio.aws.wafv2.model.BodyParsingFallbackBehavior
    ] = Optional.Absent,
    oversizeHandling: Optional[zio.aws.wafv2.model.OversizeHandling] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.JsonBody = {
    import JsonBody.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.JsonBody
      .builder()
      .matchPattern(matchPattern.buildAwsValue())
      .matchScope(matchScope.unwrap)
      .optionallyWith(invalidFallbackBehavior.map(value => value.unwrap))(
        _.invalidFallbackBehavior
      )
      .optionallyWith(oversizeHandling.map(value => value.unwrap))(
        _.oversizeHandling
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.JsonBody.ReadOnly =
    zio.aws.wafv2.model.JsonBody.wrap(buildAwsValue())
}
object JsonBody {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.JsonBody] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.JsonBody = zio.aws.wafv2.model.JsonBody(
      matchPattern.asEditable,
      matchScope,
      invalidFallbackBehavior.map(value => value),
      oversizeHandling.map(value => value)
    )
    def matchPattern: zio.aws.wafv2.model.JsonMatchPattern.ReadOnly
    def matchScope: zio.aws.wafv2.model.JsonMatchScope
    def invalidFallbackBehavior
        : Optional[zio.aws.wafv2.model.BodyParsingFallbackBehavior]
    def oversizeHandling: Optional[zio.aws.wafv2.model.OversizeHandling]
    def getMatchPattern
        : ZIO[Any, Nothing, zio.aws.wafv2.model.JsonMatchPattern.ReadOnly] =
      ZIO.succeed(matchPattern)
    def getMatchScope: ZIO[Any, Nothing, zio.aws.wafv2.model.JsonMatchScope] =
      ZIO.succeed(matchScope)
    def getInvalidFallbackBehavior
        : ZIO[Any, AwsError, zio.aws.wafv2.model.BodyParsingFallbackBehavior] =
      AwsError.unwrapOptionField(
        "invalidFallbackBehavior",
        invalidFallbackBehavior
      )
    def getOversizeHandling
        : ZIO[Any, AwsError, zio.aws.wafv2.model.OversizeHandling] =
      AwsError.unwrapOptionField("oversizeHandling", oversizeHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.JsonBody
  ) extends zio.aws.wafv2.model.JsonBody.ReadOnly {
    override val matchPattern: zio.aws.wafv2.model.JsonMatchPattern.ReadOnly =
      zio.aws.wafv2.model.JsonMatchPattern.wrap(impl.matchPattern())
    override val matchScope: zio.aws.wafv2.model.JsonMatchScope =
      zio.aws.wafv2.model.JsonMatchScope.wrap(impl.matchScope())
    override val invalidFallbackBehavior
        : Optional[zio.aws.wafv2.model.BodyParsingFallbackBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invalidFallbackBehavior())
        .map(value =>
          zio.aws.wafv2.model.BodyParsingFallbackBehavior.wrap(value)
        )
    override val oversizeHandling
        : Optional[zio.aws.wafv2.model.OversizeHandling] = zio.aws.core.internal
      .optionalFromNullable(impl.oversizeHandling())
      .map(value => zio.aws.wafv2.model.OversizeHandling.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.JsonBody
  ): zio.aws.wafv2.model.JsonBody.ReadOnly = new Wrapper(impl)
}
