package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateIpSetResponse(
    summary: Optional[zio.aws.wafv2.model.IPSetSummary] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CreateIpSetResponse = {
    import CreateIpSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CreateIpSetResponse
      .builder()
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CreateIpSetResponse.ReadOnly =
    zio.aws.wafv2.model.CreateIpSetResponse.wrap(buildAwsValue())
}
object CreateIpSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CreateIpSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CreateIpSetResponse =
      zio.aws.wafv2.model
        .CreateIpSetResponse(summary.map(value => value.asEditable))
    def summary: Optional[zio.aws.wafv2.model.IPSetSummary.ReadOnly]
    def getSummary
        : ZIO[Any, AwsError, zio.aws.wafv2.model.IPSetSummary.ReadOnly] =
      AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CreateIpSetResponse
  ) extends zio.aws.wafv2.model.CreateIpSetResponse.ReadOnly {
    override val summary: Optional[zio.aws.wafv2.model.IPSetSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summary())
        .map(value => zio.aws.wafv2.model.IPSetSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CreateIpSetResponse
  ): zio.aws.wafv2.model.CreateIpSetResponse.ReadOnly = new Wrapper(impl)
}
