package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CheckCapacityRequest(
    scope: zio.aws.wafv2.model.Scope,
    rules: Iterable[zio.aws.wafv2.model.Rule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CheckCapacityRequest = {
    import CheckCapacityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CheckCapacityRequest
      .builder()
      .scope(scope.unwrap)
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CheckCapacityRequest.ReadOnly =
    zio.aws.wafv2.model.CheckCapacityRequest.wrap(buildAwsValue())
}
object CheckCapacityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CheckCapacityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CheckCapacityRequest =
      zio.aws.wafv2.model.CheckCapacityRequest(
        scope,
        rules.map { item =>
          item.asEditable
        }
      )
    def scope: zio.aws.wafv2.model.Scope
    def rules: List[zio.aws.wafv2.model.Rule.ReadOnly]
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getRules: ZIO[Any, Nothing, List[zio.aws.wafv2.model.Rule.ReadOnly]] =
      ZIO.succeed(rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CheckCapacityRequest
  ) extends zio.aws.wafv2.model.CheckCapacityRequest.ReadOnly {
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val rules: List[zio.aws.wafv2.model.Rule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.Rule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CheckCapacityRequest
  ): zio.aws.wafv2.model.CheckCapacityRequest.ReadOnly = new Wrapper(impl)
}
