package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  CapacityUnit,
  LabelName,
  EntityId,
  ResourceArn,
  EntityDescription,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class RuleGroup(
    name: EntityName,
    id: EntityId,
    capacity: CapacityUnit,
    arn: ResourceArn,
    description: Optional[EntityDescription] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.wafv2.model.Rule]] = Optional.Absent,
    visibilityConfig: zio.aws.wafv2.model.VisibilityConfig,
    labelNamespace: Optional[LabelName] = Optional.Absent,
    customResponseBodies: Optional[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody]
    ] = Optional.Absent,
    availableLabels: Optional[Iterable[zio.aws.wafv2.model.LabelSummary]] =
      Optional.Absent,
    consumedLabels: Optional[Iterable[zio.aws.wafv2.model.LabelSummary]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.RuleGroup = {
    import RuleGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RuleGroup
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .id(EntityId.unwrap(id): java.lang.String)
      .capacity(CapacityUnit.unwrap(capacity): java.lang.Long)
      .arn(ResourceArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .visibilityConfig(visibilityConfig.buildAwsValue())
      .optionallyWith(
        labelNamespace.map(value => LabelName.unwrap(value): java.lang.String)
      )(_.labelNamespace)
      .optionallyWith(
        customResponseBodies.map(value =>
          value
            .map({ case (key, value) =>
              (EntityName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.customResponseBodies)
      .optionallyWith(
        availableLabels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availableLabels)
      .optionallyWith(
        consumedLabels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumedLabels)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RuleGroup.ReadOnly =
    zio.aws.wafv2.model.RuleGroup.wrap(buildAwsValue())
}
object RuleGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.RuleGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RuleGroup =
      zio.aws.wafv2.model.RuleGroup(
        name,
        id,
        capacity,
        arn,
        description.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        visibilityConfig.asEditable,
        labelNamespace.map(value => value),
        customResponseBodies.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        availableLabels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        consumedLabels.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: EntityName
    def id: EntityId
    def capacity: CapacityUnit
    def arn: ResourceArn
    def description: Optional[EntityDescription]
    def rules: Optional[List[zio.aws.wafv2.model.Rule.ReadOnly]]
    def visibilityConfig: zio.aws.wafv2.model.VisibilityConfig.ReadOnly
    def labelNamespace: Optional[LabelName]
    def customResponseBodies: Optional[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ]
    def availableLabels
        : Optional[List[zio.aws.wafv2.model.LabelSummary.ReadOnly]]
    def consumedLabels
        : Optional[List[zio.aws.wafv2.model.LabelSummary.ReadOnly]]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(id)
    def getCapacity: ZIO[Any, Nothing, CapacityUnit] = ZIO.succeed(capacity)
    def getArn: ZIO[Any, Nothing, ResourceArn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRules: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getVisibilityConfig
        : ZIO[Any, Nothing, zio.aws.wafv2.model.VisibilityConfig.ReadOnly] =
      ZIO.succeed(visibilityConfig)
    def getLabelNamespace: ZIO[Any, AwsError, LabelName] =
      AwsError.unwrapOptionField("labelNamespace", labelNamespace)
    def getCustomResponseBodies: ZIO[Any, AwsError, Map[
      EntityName,
      zio.aws.wafv2.model.CustomResponseBody.ReadOnly
    ]] =
      AwsError.unwrapOptionField("customResponseBodies", customResponseBodies)
    def getAvailableLabels
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.LabelSummary.ReadOnly]] =
      AwsError.unwrapOptionField("availableLabels", availableLabels)
    def getConsumedLabels
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.LabelSummary.ReadOnly]] =
      AwsError.unwrapOptionField("consumedLabels", consumedLabels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RuleGroup
  ) extends zio.aws.wafv2.model.RuleGroup.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val id: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.id())
    override val capacity: CapacityUnit =
      zio.aws.wafv2.model.primitives.CapacityUnit(impl.capacity())
    override val arn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.arn())
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val rules: Optional[List[zio.aws.wafv2.model.Rule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.Rule.wrap(item)
          }.toList
        )
    override val visibilityConfig
        : zio.aws.wafv2.model.VisibilityConfig.ReadOnly =
      zio.aws.wafv2.model.VisibilityConfig.wrap(impl.visibilityConfig())
    override val labelNamespace: Optional[LabelName] = zio.aws.core.internal
      .optionalFromNullable(impl.labelNamespace())
      .map(value => zio.aws.wafv2.model.primitives.LabelName(value))
    override val customResponseBodies: Optional[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customResponseBodies())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wafv2.model.primitives.EntityName(
              key
            ) -> zio.aws.wafv2.model.CustomResponseBody.wrap(value)
          })
          .toMap
      )
    override val availableLabels
        : Optional[List[zio.aws.wafv2.model.LabelSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableLabels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.LabelSummary.wrap(item)
          }.toList
        )
    override val consumedLabels
        : Optional[List[zio.aws.wafv2.model.LabelSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumedLabels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.LabelSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RuleGroup
  ): zio.aws.wafv2.model.RuleGroup.ReadOnly = new Wrapper(impl)
}
