package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{VersionKeyString, EntityName, VendorName}
import scala.jdk.CollectionConverters._
final case class DescribeManagedRuleGroupRequest(
    vendorName: VendorName,
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    versionName: Optional[VersionKeyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupRequest = {
    import DescribeManagedRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupRequest
      .builder()
      .vendorName(VendorName.unwrap(vendorName): java.lang.String)
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .optionallyWith(
        versionName.map(value =>
          VersionKeyString.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.DescribeManagedRuleGroupRequest.ReadOnly =
    zio.aws.wafv2.model.DescribeManagedRuleGroupRequest.wrap(buildAwsValue())
}
object DescribeManagedRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.DescribeManagedRuleGroupRequest =
      zio.aws.wafv2.model.DescribeManagedRuleGroupRequest(
        vendorName,
        name,
        scope,
        versionName.map(value => value)
      )
    def vendorName: VendorName
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def versionName: Optional[VersionKeyString]
    def getVendorName: ZIO[Any, Nothing, VendorName] = ZIO.succeed(vendorName)
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getVersionName: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("versionName", versionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupRequest
  ) extends zio.aws.wafv2.model.DescribeManagedRuleGroupRequest.ReadOnly {
    override val vendorName: VendorName =
      zio.aws.wafv2.model.primitives.VendorName(impl.vendorName())
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val versionName: Optional[VersionKeyString] = zio.aws.core.internal
      .optionalFromNullable(impl.versionName())
      .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupRequest
  ): zio.aws.wafv2.model.DescribeManagedRuleGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
