package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.LockToken
import scala.jdk.CollectionConverters._
final case class UpdateRegexPatternSetResponse(
    nextLockToken: Optional[LockToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetResponse = {
    import UpdateRegexPatternSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetResponse
      .builder()
      .optionallyWith(
        nextLockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.nextLockToken)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.UpdateRegexPatternSetResponse.ReadOnly =
    zio.aws.wafv2.model.UpdateRegexPatternSetResponse.wrap(buildAwsValue())
}
object UpdateRegexPatternSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.UpdateRegexPatternSetResponse =
      zio.aws.wafv2.model
        .UpdateRegexPatternSetResponse(nextLockToken.map(value => value))
    def nextLockToken: Optional[LockToken]
    def getNextLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("nextLockToken", nextLockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetResponse
  ) extends zio.aws.wafv2.model.UpdateRegexPatternSetResponse.ReadOnly {
    override val nextLockToken: Optional[LockToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextLockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetResponse
  ): zio.aws.wafv2.model.UpdateRegexPatternSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
