package zio.aws.wafv2.model
import scala.jdk.CollectionConverters._
sealed trait TextTransformationType {
  def unwrap: software.amazon.awssdk.services.wafv2.model.TextTransformationType
}
object TextTransformationType {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.TextTransformationType
  ): zio.aws.wafv2.model.TextTransformationType = value match {
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.COMPRESS_WHITE_SPACE =>
      val r = COMPRESS_WHITE_SPACE
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.HTML_ENTITY_DECODE =>
      val r = HTML_ENTITY_DECODE
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.LOWERCASE =>
      val r = LOWERCASE
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.CMD_LINE =>
      val r = CMD_LINE
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.URL_DECODE =>
      val r = URL_DECODE
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.BASE64_DECODE =>
      val r = BASE64_DECODE
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.HEX_DECODE =>
      val r = HEX_DECODE
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.MD5 =>
      val r = MD5
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.REPLACE_COMMENTS =>
      val r = REPLACE_COMMENTS
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.ESCAPE_SEQ_DECODE =>
      val r = ESCAPE_SEQ_DECODE
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.SQL_HEX_DECODE =>
      val r = SQL_HEX_DECODE
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.CSS_DECODE =>
      val r = CSS_DECODE
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.JS_DECODE =>
      val r = JS_DECODE
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.NORMALIZE_PATH =>
      val r = NORMALIZE_PATH
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.NORMALIZE_PATH_WIN =>
      val r = NORMALIZE_PATH_WIN
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.REMOVE_NULLS =>
      val r = REMOVE_NULLS
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.REPLACE_NULLS =>
      val r = REPLACE_NULLS
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.BASE64_DECODE_EXT =>
      val r = BASE64_DECODE_EXT
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.URL_DECODE_UNI =>
      val r = URL_DECODE_UNI
      r
    case software.amazon.awssdk.services.wafv2.model.TextTransformationType.UTF8_TO_UNICODE =>
      val r = UTF8_TO_UNICODE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.NONE
  }
  case object COMPRESS_WHITE_SPACE
      extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.COMPRESS_WHITE_SPACE
  }
  case object HTML_ENTITY_DECODE
      extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.HTML_ENTITY_DECODE
  }
  case object LOWERCASE extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.LOWERCASE
  }
  case object CMD_LINE extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.CMD_LINE
  }
  case object URL_DECODE extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.URL_DECODE
  }
  case object BASE64_DECODE extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.BASE64_DECODE
  }
  case object HEX_DECODE extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.HEX_DECODE
  }
  case object MD5 extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.MD5
  }
  case object REPLACE_COMMENTS
      extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.REPLACE_COMMENTS
  }
  case object ESCAPE_SEQ_DECODE
      extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.ESCAPE_SEQ_DECODE
  }
  case object SQL_HEX_DECODE
      extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.SQL_HEX_DECODE
  }
  case object CSS_DECODE extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.CSS_DECODE
  }
  case object JS_DECODE extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.JS_DECODE
  }
  case object NORMALIZE_PATH
      extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.NORMALIZE_PATH
  }
  case object NORMALIZE_PATH_WIN
      extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.NORMALIZE_PATH_WIN
  }
  case object REMOVE_NULLS extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.REMOVE_NULLS
  }
  case object REPLACE_NULLS extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.REPLACE_NULLS
  }
  case object BASE64_DECODE_EXT
      extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.BASE64_DECODE_EXT
  }
  case object URL_DECODE_UNI
      extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.URL_DECODE_UNI
  }
  case object UTF8_TO_UNICODE
      extends zio.aws.wafv2.model.TextTransformationType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.TextTransformationType =
      software.amazon.awssdk.services.wafv2.model.TextTransformationType.UTF8_TO_UNICODE
  }
}
