package zio.aws.wafv2.model
import scala.jdk.CollectionConverters._
sealed trait PayloadType {
  def unwrap: software.amazon.awssdk.services.wafv2.model.PayloadType
}
object PayloadType {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.PayloadType
  ): zio.aws.wafv2.model.PayloadType = value match {
    case software.amazon.awssdk.services.wafv2.model.PayloadType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.PayloadType.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.wafv2.model.PayloadType.FORM_ENCODED =>
      val r = FORM_ENCODED
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.PayloadType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.PayloadType =
      software.amazon.awssdk.services.wafv2.model.PayloadType.UNKNOWN_TO_SDK_VERSION
  }
  case object JSON extends zio.aws.wafv2.model.PayloadType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.PayloadType =
      software.amazon.awssdk.services.wafv2.model.PayloadType.JSON
  }
  case object FORM_ENCODED extends zio.aws.wafv2.model.PayloadType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.PayloadType =
      software.amazon.awssdk.services.wafv2.model.PayloadType.FORM_ENCODED
  }
}
