package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class ListResourcesForWebAclResponse(
    resourceArns: Optional[Iterable[ResourceArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclResponse = {
    import ListResourcesForWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclResponse
      .builder()
      .optionallyWith(
        resourceArns.map(value =>
          value.map { item =>
            ResourceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceArns)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListResourcesForWebAclResponse.ReadOnly =
    zio.aws.wafv2.model.ListResourcesForWebAclResponse.wrap(buildAwsValue())
}
object ListResourcesForWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListResourcesForWebAclResponse =
      zio.aws.wafv2.model
        .ListResourcesForWebAclResponse(resourceArns.map(value => value))
    def resourceArns: Optional[List[ResourceArn]]
    def getResourceArns: ZIO[Any, AwsError, List[ResourceArn]] =
      AwsError.unwrapOptionField("resourceArns", resourceArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclResponse
  ) extends zio.aws.wafv2.model.ListResourcesForWebAclResponse.ReadOnly {
    override val resourceArns: Optional[List[ResourceArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.primitives.ResourceArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclResponse
  ): zio.aws.wafv2.model.ListResourcesForWebAclResponse.ReadOnly = new Wrapper(
    impl
  )
}
