package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLoggingConfigurationResponse(
    loggingConfiguration: Optional[zio.aws.wafv2.model.LoggingConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationResponse = {
    import GetLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationResponse
      .builder()
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetLoggingConfigurationResponse.ReadOnly =
    zio.aws.wafv2.model.GetLoggingConfigurationResponse.wrap(buildAwsValue())
}
object GetLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetLoggingConfigurationResponse =
      zio.aws.wafv2.model.GetLoggingConfigurationResponse(
        loggingConfiguration.map(value => value.asEditable)
      )
    def loggingConfiguration
        : Optional[zio.aws.wafv2.model.LoggingConfiguration.ReadOnly]
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.LoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationResponse
  ) extends zio.aws.wafv2.model.GetLoggingConfigurationResponse.ReadOnly {
    override val loggingConfiguration
        : Optional[zio.aws.wafv2.model.LoggingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfiguration())
        .map(value => zio.aws.wafv2.model.LoggingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationResponse
  ): zio.aws.wafv2.model.GetLoggingConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
