package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CaptchaConfig(
    immunityTimeProperty: Optional[zio.aws.wafv2.model.ImmunityTimeProperty] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CaptchaConfig = {
    import CaptchaConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CaptchaConfig
      .builder()
      .optionallyWith(immunityTimeProperty.map(value => value.buildAwsValue()))(
        _.immunityTimeProperty
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CaptchaConfig.ReadOnly =
    zio.aws.wafv2.model.CaptchaConfig.wrap(buildAwsValue())
}
object CaptchaConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CaptchaConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CaptchaConfig = zio.aws.wafv2.model
      .CaptchaConfig(immunityTimeProperty.map(value => value.asEditable))
    def immunityTimeProperty
        : Optional[zio.aws.wafv2.model.ImmunityTimeProperty.ReadOnly]
    def getImmunityTimeProperty: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.ImmunityTimeProperty.ReadOnly
    ] = AwsError.unwrapOptionField("immunityTimeProperty", immunityTimeProperty)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CaptchaConfig
  ) extends zio.aws.wafv2.model.CaptchaConfig.ReadOnly {
    override val immunityTimeProperty
        : Optional[zio.aws.wafv2.model.ImmunityTimeProperty.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.immunityTimeProperty())
        .map(value => zio.aws.wafv2.model.ImmunityTimeProperty.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CaptchaConfig
  ): zio.aws.wafv2.model.CaptchaConfig.ReadOnly = new Wrapper(impl)
}
