package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{ResourceArn, EntityId, EntityName}
import scala.jdk.CollectionConverters._
final case class GetRuleGroupRequest(
    name: Optional[EntityName] = Optional.Absent,
    scope: Optional[zio.aws.wafv2.model.Scope] = Optional.Absent,
    id: Optional[EntityId] = Optional.Absent,
    arn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest = {
    import GetRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest
      .builder()
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .optionallyWith(
        id.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetRuleGroupRequest.ReadOnly =
    zio.aws.wafv2.model.GetRuleGroupRequest.wrap(buildAwsValue())
}
object GetRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetRuleGroupRequest =
      zio.aws.wafv2.model.GetRuleGroupRequest(
        name.map(value => value),
        scope.map(value => value),
        id.map(value => value),
        arn.map(value => value)
      )
    def name: Optional[EntityName]
    def scope: Optional[zio.aws.wafv2.model.Scope]
    def id: Optional[EntityId]
    def arn: Optional[ResourceArn]
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getScope: ZIO[Any, AwsError, zio.aws.wafv2.model.Scope] =
      AwsError.unwrapOptionField("scope", scope)
    def getId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest
  ) extends zio.aws.wafv2.model.GetRuleGroupRequest.ReadOnly {
    override val name: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.wafv2.model.primitives.EntityName(value))
    override val scope: Optional[zio.aws.wafv2.model.Scope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value => zio.aws.wafv2.model.Scope.wrap(value))
    override val id: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.wafv2.model.primitives.EntityId(value))
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.wafv2.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest
  ): zio.aws.wafv2.model.GetRuleGroupRequest.ReadOnly = new Wrapper(impl)
}
