package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AndStatement(
    statements: Iterable[zio.aws.wafv2.model.Statement]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.AndStatement = {
    import AndStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.AndStatement
      .builder()
      .statements(statements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.AndStatement.ReadOnly =
    zio.aws.wafv2.model.AndStatement.wrap(buildAwsValue())
}
object AndStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.AndStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.AndStatement =
      zio.aws.wafv2.model.AndStatement(statements.map { item =>
        item.asEditable
      })
    def statements: List[zio.aws.wafv2.model.Statement.ReadOnly]
    def getStatements
        : ZIO[Any, Nothing, List[zio.aws.wafv2.model.Statement.ReadOnly]] =
      ZIO.succeed(statements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.AndStatement
  ) extends zio.aws.wafv2.model.AndStatement.ReadOnly {
    override val statements: List[zio.aws.wafv2.model.Statement.ReadOnly] = impl
      .statements()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.Statement.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.AndStatement
  ): zio.aws.wafv2.model.AndStatement.ReadOnly = new Wrapper(impl)
}
