package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{
  ConsumedCapacity,
  LabelName,
  EntityId,
  ResourceArn,
  EntityDescription,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class WebACL(
    name: EntityName,
    id: EntityId,
    arn: ResourceArn,
    defaultAction: zio.aws.wafv2.model.DefaultAction,
    description: Option[EntityDescription] = None,
    rules: Option[Iterable[zio.aws.wafv2.model.Rule]] = None,
    visibilityConfig: zio.aws.wafv2.model.VisibilityConfig,
    capacity: Option[ConsumedCapacity] = None,
    preProcessFirewallManagerRuleGroups: Option[
      Iterable[zio.aws.wafv2.model.FirewallManagerRuleGroup]
    ] = None,
    postProcessFirewallManagerRuleGroups: Option[
      Iterable[zio.aws.wafv2.model.FirewallManagerRuleGroup]
    ] = None,
    managedByFirewallManager: Option[Boolean] = None,
    labelNamespace: Option[LabelName] = None,
    customResponseBodies: Option[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody]
    ] = None,
    captchaConfig: Option[zio.aws.wafv2.model.CaptchaConfig] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.WebACL = {
    import WebACL.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.WebACL
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .id(EntityId.unwrap(id): java.lang.String)
      .arn(ResourceArn.unwrap(arn): java.lang.String)
      .defaultAction(defaultAction.buildAwsValue())
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .visibilityConfig(visibilityConfig.buildAwsValue())
      .optionallyWith(
        capacity.map(value => ConsumedCapacity.unwrap(value): java.lang.Long)
      )(_.capacity)
      .optionallyWith(
        preProcessFirewallManagerRuleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.preProcessFirewallManagerRuleGroups)
      .optionallyWith(
        postProcessFirewallManagerRuleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.postProcessFirewallManagerRuleGroups)
      .optionallyWith(
        managedByFirewallManager.map(value => value: java.lang.Boolean)
      )(_.managedByFirewallManager)
      .optionallyWith(
        labelNamespace.map(value => LabelName.unwrap(value): java.lang.String)
      )(_.labelNamespace)
      .optionallyWith(
        customResponseBodies.map(value =>
          value
            .map({ case (key, value) =>
              (EntityName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.customResponseBodies)
      .optionallyWith(captchaConfig.map(value => value.buildAwsValue()))(
        _.captchaConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.WebACL.ReadOnly =
    zio.aws.wafv2.model.WebACL.wrap(buildAwsValue())
}
object WebACL {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.WebACL] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.WebACL = zio.aws.wafv2.model.WebACL(
      name,
      id,
      arn,
      defaultAction.asEditable,
      description.map(value => value),
      rules.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      visibilityConfig.asEditable,
      capacity.map(value => value),
      preProcessFirewallManagerRuleGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      postProcessFirewallManagerRuleGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      managedByFirewallManager.map(value => value),
      labelNamespace.map(value => value),
      customResponseBodies.map(value =>
        value.map({ case (key, value) =>
          key -> value.asEditable
        })
      ),
      captchaConfig.map(value => value.asEditable)
    )
    def name: EntityName
    def id: EntityId
    def arn: ResourceArn
    def defaultAction: zio.aws.wafv2.model.DefaultAction.ReadOnly
    def description: Option[EntityDescription]
    def rules: Option[List[zio.aws.wafv2.model.Rule.ReadOnly]]
    def visibilityConfig: zio.aws.wafv2.model.VisibilityConfig.ReadOnly
    def capacity: Option[ConsumedCapacity]
    def preProcessFirewallManagerRuleGroups
        : Option[List[zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly]]
    def postProcessFirewallManagerRuleGroups
        : Option[List[zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly]]
    def managedByFirewallManager: Option[Boolean]
    def labelNamespace: Option[LabelName]
    def customResponseBodies: Option[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ]
    def captchaConfig: Option[zio.aws.wafv2.model.CaptchaConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ResourceArn] = ZIO.succeed(arn)
    def getDefaultAction
        : ZIO[Any, Nothing, zio.aws.wafv2.model.DefaultAction.ReadOnly] =
      ZIO.succeed(defaultAction)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRules: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getVisibilityConfig
        : ZIO[Any, Nothing, zio.aws.wafv2.model.VisibilityConfig.ReadOnly] =
      ZIO.succeed(visibilityConfig)
    def getCapacity: ZIO[Any, AwsError, ConsumedCapacity] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getPreProcessFirewallManagerRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "preProcessFirewallManagerRuleGroups",
      preProcessFirewallManagerRuleGroups
    )
    def getPostProcessFirewallManagerRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "postProcessFirewallManagerRuleGroups",
      postProcessFirewallManagerRuleGroups
    )
    def getManagedByFirewallManager: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("managedByFirewallManager", managedByFirewallManager)
    def getLabelNamespace: ZIO[Any, AwsError, LabelName] =
      AwsError.unwrapOptionField("labelNamespace", labelNamespace)
    def getCustomResponseBodies: ZIO[Any, AwsError, Map[
      EntityName,
      zio.aws.wafv2.model.CustomResponseBody.ReadOnly
    ]] =
      AwsError.unwrapOptionField("customResponseBodies", customResponseBodies)
    def getCaptchaConfig
        : ZIO[Any, AwsError, zio.aws.wafv2.model.CaptchaConfig.ReadOnly] =
      AwsError.unwrapOptionField("captchaConfig", captchaConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.WebACL
  ) extends zio.aws.wafv2.model.WebACL.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val id: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.id())
    override val arn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.arn())
    override val defaultAction: zio.aws.wafv2.model.DefaultAction.ReadOnly =
      zio.aws.wafv2.model.DefaultAction.wrap(impl.defaultAction())
    override val description: Option[EntityDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val rules: Option[List[zio.aws.wafv2.model.Rule.ReadOnly]] = scala
      .Option(impl.rules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.Rule.wrap(item)
        }.toList
      )
    override val visibilityConfig
        : zio.aws.wafv2.model.VisibilityConfig.ReadOnly =
      zio.aws.wafv2.model.VisibilityConfig.wrap(impl.visibilityConfig())
    override val capacity: Option[ConsumedCapacity] = scala
      .Option(impl.capacity())
      .map(value => zio.aws.wafv2.model.primitives.ConsumedCapacity(value))
    override val preProcessFirewallManagerRuleGroups
        : Option[List[zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly]] =
      scala
        .Option(impl.preProcessFirewallManagerRuleGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.FirewallManagerRuleGroup.wrap(item)
          }.toList
        )
    override val postProcessFirewallManagerRuleGroups
        : Option[List[zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly]] =
      scala
        .Option(impl.postProcessFirewallManagerRuleGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.FirewallManagerRuleGroup.wrap(item)
          }.toList
        )
    override val managedByFirewallManager: Option[Boolean] =
      scala.Option(impl.managedByFirewallManager()).map(value => value: Boolean)
    override val labelNamespace: Option[LabelName] = scala
      .Option(impl.labelNamespace())
      .map(value => zio.aws.wafv2.model.primitives.LabelName(value))
    override val customResponseBodies: Option[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ] = scala
      .Option(impl.customResponseBodies())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wafv2.model.primitives.EntityName(
              key
            ) -> zio.aws.wafv2.model.CustomResponseBody.wrap(value)
          })
          .toMap
      )
    override val captchaConfig
        : Option[zio.aws.wafv2.model.CaptchaConfig.ReadOnly] = scala
      .Option(impl.captchaConfig())
      .map(value => zio.aws.wafv2.model.CaptchaConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.WebACL
  ): zio.aws.wafv2.model.WebACL.ReadOnly = new Wrapper(impl)
}
