package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class RuleGroupReferenceStatement(
    arn: ResourceArn,
    excludedRules: Option[Iterable[zio.aws.wafv2.model.ExcludedRule]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RuleGroupReferenceStatement = {
    import RuleGroupReferenceStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RuleGroupReferenceStatement
      .builder()
      .arn(ResourceArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        excludedRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludedRules)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RuleGroupReferenceStatement.ReadOnly =
    zio.aws.wafv2.model.RuleGroupReferenceStatement.wrap(buildAwsValue())
}
object RuleGroupReferenceStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RuleGroupReferenceStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RuleGroupReferenceStatement =
      zio.aws.wafv2.model.RuleGroupReferenceStatement(
        arn,
        excludedRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: ResourceArn
    def excludedRules: Option[List[zio.aws.wafv2.model.ExcludedRule.ReadOnly]]
    def getArn: ZIO[Any, Nothing, ResourceArn] = ZIO.succeed(arn)
    def getExcludedRules
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.ExcludedRule.ReadOnly]] =
      AwsError.unwrapOptionField("excludedRules", excludedRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RuleGroupReferenceStatement
  ) extends zio.aws.wafv2.model.RuleGroupReferenceStatement.ReadOnly {
    override val arn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.arn())
    override val excludedRules
        : Option[List[zio.aws.wafv2.model.ExcludedRule.ReadOnly]] = scala
      .Option(impl.excludedRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.ExcludedRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RuleGroupReferenceStatement
  ): zio.aws.wafv2.model.RuleGroupReferenceStatement.ReadOnly = new Wrapper(
    impl
  )
}
