package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.LockToken
import scala.jdk.CollectionConverters._
final case class GetRuleGroupResponse(
    ruleGroup: Option[zio.aws.wafv2.model.RuleGroup] = None,
    lockToken: Option[LockToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetRuleGroupResponse = {
    import GetRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetRuleGroupResponse
      .builder()
      .optionallyWith(ruleGroup.map(value => value.buildAwsValue()))(
        _.ruleGroup
      )
      .optionallyWith(
        lockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.lockToken)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetRuleGroupResponse.ReadOnly =
    zio.aws.wafv2.model.GetRuleGroupResponse.wrap(buildAwsValue())
}
object GetRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetRuleGroupResponse =
      zio.aws.wafv2.model.GetRuleGroupResponse(
        ruleGroup.map(value => value.asEditable),
        lockToken.map(value => value)
      )
    def ruleGroup: Option[zio.aws.wafv2.model.RuleGroup.ReadOnly]
    def lockToken: Option[LockToken]
    def getRuleGroup
        : ZIO[Any, AwsError, zio.aws.wafv2.model.RuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("ruleGroup", ruleGroup)
    def getLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("lockToken", lockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetRuleGroupResponse
  ) extends zio.aws.wafv2.model.GetRuleGroupResponse.ReadOnly {
    override val ruleGroup: Option[zio.aws.wafv2.model.RuleGroup.ReadOnly] =
      scala
        .Option(impl.ruleGroup())
        .map(value => zio.aws.wafv2.model.RuleGroup.wrap(value))
    override val lockToken: Option[LockToken] = scala
      .Option(impl.lockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetRuleGroupResponse
  ): zio.aws.wafv2.model.GetRuleGroupResponse.ReadOnly = new Wrapper(impl)
}
