package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRateBasedStatementManagedKeysResponse(
    managedKeysIPV4: Option[
      zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet
    ] = None,
    managedKeysIPV6: Option[
      zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysResponse = {
    import GetRateBasedStatementManagedKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysResponse
      .builder()
      .optionallyWith(managedKeysIPV4.map(value => value.buildAwsValue()))(
        _.managedKeysIPV4
      )
      .optionallyWith(managedKeysIPV6.map(value => value.buildAwsValue()))(
        _.managedKeysIPV6
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.GetRateBasedStatementManagedKeysResponse.ReadOnly =
    zio.aws.wafv2.model.GetRateBasedStatementManagedKeysResponse
      .wrap(buildAwsValue())
}
object GetRateBasedStatementManagedKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafv2.model.GetRateBasedStatementManagedKeysResponse =
      zio.aws.wafv2.model.GetRateBasedStatementManagedKeysResponse(
        managedKeysIPV4.map(value => value.asEditable),
        managedKeysIPV6.map(value => value.asEditable)
      )
    def managedKeysIPV4: Option[
      zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet.ReadOnly
    ]
    def managedKeysIPV6: Option[
      zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet.ReadOnly
    ]
    def getManagedKeysIPV4: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet.ReadOnly
    ] = AwsError.unwrapOptionField("managedKeysIPV4", managedKeysIPV4)
    def getManagedKeysIPV6: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet.ReadOnly
    ] = AwsError.unwrapOptionField("managedKeysIPV6", managedKeysIPV6)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysResponse
  ) extends zio.aws.wafv2.model.GetRateBasedStatementManagedKeysResponse.ReadOnly {
    override val managedKeysIPV4: Option[
      zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet.ReadOnly
    ] = scala
      .Option(impl.managedKeysIPV4())
      .map(value =>
        zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet.wrap(value)
      )
    override val managedKeysIPV6: Option[
      zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet.ReadOnly
    ] = scala
      .Option(impl.managedKeysIPV6())
      .map(value =>
        zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysResponse
  ): zio.aws.wafv2.model.GetRateBasedStatementManagedKeysResponse.ReadOnly =
    new Wrapper(impl)
}
