package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.ConsumedCapacity
import scala.jdk.CollectionConverters._
final case class CheckCapacityResponse(
    capacity: Option[ConsumedCapacity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CheckCapacityResponse = {
    import CheckCapacityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CheckCapacityResponse
      .builder()
      .optionallyWith(
        capacity.map(value => ConsumedCapacity.unwrap(value): java.lang.Long)
      )(_.capacity)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CheckCapacityResponse.ReadOnly =
    zio.aws.wafv2.model.CheckCapacityResponse.wrap(buildAwsValue())
}
object CheckCapacityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CheckCapacityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CheckCapacityResponse =
      zio.aws.wafv2.model.CheckCapacityResponse(capacity.map(value => value))
    def capacity: Option[ConsumedCapacity]
    def getCapacity: ZIO[Any, AwsError, ConsumedCapacity] =
      AwsError.unwrapOptionField("capacity", capacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CheckCapacityResponse
  ) extends zio.aws.wafv2.model.CheckCapacityResponse.ReadOnly {
    override val capacity: Option[ConsumedCapacity] = scala
      .Option(impl.capacity())
      .map(value => zio.aws.wafv2.model.primitives.ConsumedCapacity(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CheckCapacityResponse
  ): zio.aws.wafv2.model.CheckCapacityResponse.ReadOnly = new Wrapper(impl)
}
