package zio.aws.wafv2
import zio.aws.wafv2.model.PutLoggingConfigurationResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.wafv2.{
  Wafv2AsyncClientBuilder,
  Wafv2AsyncClient
}
import software.amazon.awssdk.services.wafv2.model.{
  ListResourcesForWebAclResponse,
  UpdateWebAclRequest,
  GetRuleGroupRequest,
  GetLoggingConfigurationRequest,
  DisassociateWebAclResponse,
  GetRegexPatternSetResponse,
  AssociateWebAclRequest,
  GetManagedRuleSetResponse,
  GetWebAclForResourceResponse,
  PutPermissionPolicyResponse,
  DeleteWebAclRequest,
  ListMobileSdkReleasesRequest,
  DeleteRuleGroupRequest,
  PutManagedRuleSetVersionsResponse,
  GetIpSetRequest,
  UpdateIpSetResponse,
  GetPermissionPolicyRequest,
  UpdateIpSetRequest,
  ListAvailableManagedRuleGroupsResponse,
  DeleteLoggingConfigurationResponse,
  DeleteRuleGroupResponse,
  DeleteFirewallManagerRuleGroupsResponse,
  PutPermissionPolicyRequest,
  CreateRegexPatternSetResponse,
  DeletePermissionPolicyResponse,
  GetIpSetResponse,
  ListIpSetsResponse,
  GenerateMobileSdkReleaseUrlRequest,
  CreateIpSetResponse,
  DeleteWebAclResponse,
  GetManagedRuleSetRequest,
  ListTagsForResourceRequest,
  GetRegexPatternSetRequest,
  CreateRuleGroupResponse,
  GenerateMobileSdkReleaseUrlResponse,
  ListRuleGroupsRequest,
  PutLoggingConfigurationRequest,
  GetPermissionPolicyResponse,
  ListLoggingConfigurationsRequest,
  DescribeManagedRuleGroupResponse,
  CheckCapacityResponse,
  DeleteIpSetRequest,
  CreateWebAclResponse,
  GetRateBasedStatementManagedKeysRequest,
  DeletePermissionPolicyRequest,
  CheckCapacityRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  UpdateManagedRuleSetVersionExpiryDateResponse,
  ListLoggingConfigurationsResponse,
  DeleteIpSetResponse,
  GetWebAclRequest,
  DeleteLoggingConfigurationRequest,
  AssociateWebAclResponse,
  UpdateRegexPatternSetResponse,
  ListAvailableManagedRuleGroupVersionsRequest,
  ListAvailableManagedRuleGroupsRequest,
  DescribeManagedRuleGroupRequest,
  DisassociateWebAclRequest,
  DeleteRegexPatternSetRequest,
  CreateRegexPatternSetRequest,
  GetSampledRequestsRequest,
  GetRateBasedStatementManagedKeysResponse,
  UpdateWebAclResponse,
  UpdateRuleGroupRequest,
  ListResourcesForWebAclRequest,
  UntagResourceRequest,
  ListMobileSdkReleasesResponse,
  CreateRuleGroupRequest,
  ListManagedRuleSetsRequest,
  ListWebAcLsResponse,
  GetWebAclResponse,
  GetLoggingConfigurationResponse,
  DeleteFirewallManagerRuleGroupsRequest,
  PutManagedRuleSetVersionsRequest,
  GetSampledRequestsResponse,
  ListRegexPatternSetsResponse,
  ListAvailableManagedRuleGroupVersionsResponse,
  GetWebAclForResourceRequest,
  GetRuleGroupResponse,
  DeleteRegexPatternSetResponse,
  ListManagedRuleSetsResponse,
  GetMobileSdkReleaseResponse,
  PutLoggingConfigurationResponse,
  TagResourceResponse,
  UpdateRuleGroupResponse,
  ListRuleGroupsResponse,
  GetMobileSdkReleaseRequest,
  UpdateRegexPatternSetRequest,
  TagResourceRequest,
  ListWebAcLsRequest,
  UpdateManagedRuleSetVersionExpiryDateRequest,
  CreateWebAclRequest,
  ListRegexPatternSetsRequest,
  ListIpSetsRequest,
  CreateIpSetRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import scala.jdk.CollectionConverters._
trait Wafv2 extends AspectSupport[Wafv2] {
  val api: Wafv2AsyncClient
  def getRuleGroup(
      request: zio.aws.wafv2.model.GetRuleGroupRequest
  ): IO[AwsError, zio.aws.wafv2.model.GetRuleGroupResponse.ReadOnly]
  def getWebACL(
      request: zio.aws.wafv2.model.GetWebAclRequest
  ): IO[AwsError, zio.aws.wafv2.model.GetWebAclResponse.ReadOnly]
  def getMobileSdkRelease(
      request: zio.aws.wafv2.model.GetMobileSdkReleaseRequest
  ): IO[AwsError, zio.aws.wafv2.model.GetMobileSdkReleaseResponse.ReadOnly]
  def getIPSet(
      request: zio.aws.wafv2.model.GetIpSetRequest
  ): IO[AwsError, zio.aws.wafv2.model.GetIpSetResponse.ReadOnly]
  def createRuleGroup(
      request: zio.aws.wafv2.model.CreateRuleGroupRequest
  ): IO[AwsError, zio.aws.wafv2.model.CreateRuleGroupResponse.ReadOnly]
  def generateMobileSdkReleaseUrl(
      request: zio.aws.wafv2.model.GenerateMobileSdkReleaseUrlRequest
  ): IO[
    AwsError,
    zio.aws.wafv2.model.GenerateMobileSdkReleaseUrlResponse.ReadOnly
  ]
  def listRuleGroups(
      request: zio.aws.wafv2.model.ListRuleGroupsRequest
  ): IO[AwsError, zio.aws.wafv2.model.ListRuleGroupsResponse.ReadOnly]
  def deleteRegexPatternSet(
      request: zio.aws.wafv2.model.DeleteRegexPatternSetRequest
  ): IO[AwsError, zio.aws.wafv2.model.DeleteRegexPatternSetResponse.ReadOnly]
  def disassociateWebACL(
      request: zio.aws.wafv2.model.DisassociateWebAclRequest
  ): IO[AwsError, zio.aws.wafv2.model.DisassociateWebAclResponse.ReadOnly]
  def listResourcesForWebACL(
      request: zio.aws.wafv2.model.ListResourcesForWebAclRequest
  ): IO[AwsError, zio.aws.wafv2.model.ListResourcesForWebAclResponse.ReadOnly]
  def createIPSet(
      request: zio.aws.wafv2.model.CreateIpSetRequest
  ): IO[AwsError, zio.aws.wafv2.model.CreateIpSetResponse.ReadOnly]
  def getWebACLForResource(
      request: zio.aws.wafv2.model.GetWebAclForResourceRequest
  ): IO[AwsError, zio.aws.wafv2.model.GetWebAclForResourceResponse.ReadOnly]
  def listRegexPatternSets(
      request: zio.aws.wafv2.model.ListRegexPatternSetsRequest
  ): IO[AwsError, zio.aws.wafv2.model.ListRegexPatternSetsResponse.ReadOnly]
  def updateIPSet(
      request: zio.aws.wafv2.model.UpdateIpSetRequest
  ): IO[AwsError, zio.aws.wafv2.model.UpdateIpSetResponse.ReadOnly]
  def updateManagedRuleSetVersionExpiryDate(
      request: zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest
  ): IO[
    AwsError,
    zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse.ReadOnly
  ]
  def getManagedRuleSet(
      request: zio.aws.wafv2.model.GetManagedRuleSetRequest
  ): IO[AwsError, zio.aws.wafv2.model.GetManagedRuleSetResponse.ReadOnly]
  def listAvailableManagedRuleGroups(
      request: zio.aws.wafv2.model.ListAvailableManagedRuleGroupsRequest
  ): IO[
    AwsError,
    zio.aws.wafv2.model.ListAvailableManagedRuleGroupsResponse.ReadOnly
  ]
  def checkCapacity(
      request: zio.aws.wafv2.model.CheckCapacityRequest
  ): IO[AwsError, zio.aws.wafv2.model.CheckCapacityResponse.ReadOnly]
  def putManagedRuleSetVersions(
      request: zio.aws.wafv2.model.PutManagedRuleSetVersionsRequest
  ): IO[
    AwsError,
    zio.aws.wafv2.model.PutManagedRuleSetVersionsResponse.ReadOnly
  ]
  def associateWebACL(
      request: zio.aws.wafv2.model.AssociateWebAclRequest
  ): IO[AwsError, zio.aws.wafv2.model.AssociateWebAclResponse.ReadOnly]
  def getRegexPatternSet(
      request: zio.aws.wafv2.model.GetRegexPatternSetRequest
  ): IO[AwsError, zio.aws.wafv2.model.GetRegexPatternSetResponse.ReadOnly]
  def untagResource(
      request: zio.aws.wafv2.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.wafv2.model.UntagResourceResponse.ReadOnly]
  def putLoggingConfiguration(
      request: zio.aws.wafv2.model.PutLoggingConfigurationRequest
  ): IO[AwsError, ReadOnly]
  def describeManagedRuleGroup(
      request: zio.aws.wafv2.model.DescribeManagedRuleGroupRequest
  ): IO[AwsError, zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.ReadOnly]
  def deleteWebACL(
      request: zio.aws.wafv2.model.DeleteWebAclRequest
  ): IO[AwsError, zio.aws.wafv2.model.DeleteWebAclResponse.ReadOnly]
  def listAvailableManagedRuleGroupVersions(
      request: zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest
  ): IO[
    AwsError,
    zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse.ReadOnly
  ]
  def createRegexPatternSet(
      request: zio.aws.wafv2.model.CreateRegexPatternSetRequest
  ): IO[AwsError, zio.aws.wafv2.model.CreateRegexPatternSetResponse.ReadOnly]
  def listWebACLs(
      request: zio.aws.wafv2.model.ListWebAcLsRequest
  ): IO[AwsError, zio.aws.wafv2.model.ListWebAcLsResponse.ReadOnly]
  def putPermissionPolicy(
      request: zio.aws.wafv2.model.PutPermissionPolicyRequest
  ): IO[AwsError, zio.aws.wafv2.model.PutPermissionPolicyResponse.ReadOnly]
  def getLoggingConfiguration(
      request: zio.aws.wafv2.model.GetLoggingConfigurationRequest
  ): IO[AwsError, zio.aws.wafv2.model.GetLoggingConfigurationResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.wafv2.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.wafv2.model.ListTagsForResourceResponse.ReadOnly]
  def deleteFirewallManagerRuleGroups(
      request: zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsRequest
  ): IO[
    AwsError,
    zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.wafv2.model.TagResourceRequest
  ): IO[AwsError, zio.aws.wafv2.model.TagResourceResponse.ReadOnly]
  def listLoggingConfigurations(
      request: zio.aws.wafv2.model.ListLoggingConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.wafv2.model.ListLoggingConfigurationsResponse.ReadOnly
  ]
  def deleteLoggingConfiguration(
      request: zio.aws.wafv2.model.DeleteLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.wafv2.model.DeleteLoggingConfigurationResponse.ReadOnly
  ]
  def listMobileSdkReleases(
      request: zio.aws.wafv2.model.ListMobileSdkReleasesRequest
  ): IO[AwsError, zio.aws.wafv2.model.ListMobileSdkReleasesResponse.ReadOnly]
  def listManagedRuleSets(
      request: zio.aws.wafv2.model.ListManagedRuleSetsRequest
  ): IO[AwsError, zio.aws.wafv2.model.ListManagedRuleSetsResponse.ReadOnly]
  def updateRuleGroup(
      request: zio.aws.wafv2.model.UpdateRuleGroupRequest
  ): IO[AwsError, zio.aws.wafv2.model.UpdateRuleGroupResponse.ReadOnly]
  def updateRegexPatternSet(
      request: zio.aws.wafv2.model.UpdateRegexPatternSetRequest
  ): IO[AwsError, zio.aws.wafv2.model.UpdateRegexPatternSetResponse.ReadOnly]
  def getRateBasedStatementManagedKeys(
      request: zio.aws.wafv2.model.GetRateBasedStatementManagedKeysRequest
  ): IO[
    AwsError,
    zio.aws.wafv2.model.GetRateBasedStatementManagedKeysResponse.ReadOnly
  ]
  def createWebACL(
      request: zio.aws.wafv2.model.CreateWebAclRequest
  ): IO[AwsError, zio.aws.wafv2.model.CreateWebAclResponse.ReadOnly]
  def getPermissionPolicy(
      request: zio.aws.wafv2.model.GetPermissionPolicyRequest
  ): IO[AwsError, zio.aws.wafv2.model.GetPermissionPolicyResponse.ReadOnly]
  def updateWebACL(
      request: zio.aws.wafv2.model.UpdateWebAclRequest
  ): IO[AwsError, zio.aws.wafv2.model.UpdateWebAclResponse.ReadOnly]
  def deleteRuleGroup(
      request: zio.aws.wafv2.model.DeleteRuleGroupRequest
  ): IO[AwsError, zio.aws.wafv2.model.DeleteRuleGroupResponse.ReadOnly]
  def listIPSets(
      request: zio.aws.wafv2.model.ListIpSetsRequest
  ): IO[AwsError, zio.aws.wafv2.model.ListIpSetsResponse.ReadOnly]
  def getSampledRequests(
      request: zio.aws.wafv2.model.GetSampledRequestsRequest
  ): IO[AwsError, zio.aws.wafv2.model.GetSampledRequestsResponse.ReadOnly]
  def deleteIPSet(
      request: zio.aws.wafv2.model.DeleteIpSetRequest
  ): IO[AwsError, zio.aws.wafv2.model.DeleteIpSetResponse.ReadOnly]
  def deletePermissionPolicy(
      request: zio.aws.wafv2.model.DeletePermissionPolicyRequest
  ): IO[AwsError, zio.aws.wafv2.model.DeletePermissionPolicyResponse.ReadOnly]
}
object Wafv2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Wafv2] = customized(identity)
  def customized(
      customization: Wafv2AsyncClientBuilder => Wafv2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Wafv2] = managed(
    customization
  ).toLayer
  def managed(
      customization: Wafv2AsyncClientBuilder => Wafv2AsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Wafv2] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = Wafv2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[Wafv2AsyncClient, Wafv2AsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[Wafv2AsyncClient, Wafv2AsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new Wafv2Impl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class Wafv2Impl[R](
      override val api: Wafv2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Wafv2
      with AwsServiceBase[R] {
    override val serviceName: String = "Wafv2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): Wafv2Impl[R1] = new Wafv2Impl(api, newAspect, r)
    def getRuleGroup(
        request: zio.aws.wafv2.model.GetRuleGroupRequest
    ): IO[AwsError, zio.aws.wafv2.model.GetRuleGroupResponse.ReadOnly] =
      asyncRequestResponse[GetRuleGroupRequest, GetRuleGroupResponse](
        "getRuleGroup",
        api.getRuleGroup
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.GetRuleGroupResponse.wrap)
        .provideEnvironment(r)
    def getWebACL(
        request: zio.aws.wafv2.model.GetWebAclRequest
    ): IO[AwsError, zio.aws.wafv2.model.GetWebAclResponse.ReadOnly] =
      asyncRequestResponse[GetWebAclRequest, GetWebAclResponse](
        "getWebACL",
        api.getWebACL
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.GetWebAclResponse.wrap)
        .provideEnvironment(r)
    def getMobileSdkRelease(
        request: zio.aws.wafv2.model.GetMobileSdkReleaseRequest
    ): IO[AwsError, zio.aws.wafv2.model.GetMobileSdkReleaseResponse.ReadOnly] =
      asyncRequestResponse[
        GetMobileSdkReleaseRequest,
        GetMobileSdkReleaseResponse
      ]("getMobileSdkRelease", api.getMobileSdkRelease)(request.buildAwsValue())
        .map(zio.aws.wafv2.model.GetMobileSdkReleaseResponse.wrap)
        .provideEnvironment(r)
    def getIPSet(
        request: zio.aws.wafv2.model.GetIpSetRequest
    ): IO[AwsError, zio.aws.wafv2.model.GetIpSetResponse.ReadOnly] =
      asyncRequestResponse[GetIpSetRequest, GetIpSetResponse](
        "getIPSet",
        api.getIPSet
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.GetIpSetResponse.wrap)
        .provideEnvironment(r)
    def createRuleGroup(
        request: zio.aws.wafv2.model.CreateRuleGroupRequest
    ): IO[AwsError, zio.aws.wafv2.model.CreateRuleGroupResponse.ReadOnly] =
      asyncRequestResponse[CreateRuleGroupRequest, CreateRuleGroupResponse](
        "createRuleGroup",
        api.createRuleGroup
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.CreateRuleGroupResponse.wrap)
        .provideEnvironment(r)
    def generateMobileSdkReleaseUrl(
        request: zio.aws.wafv2.model.GenerateMobileSdkReleaseUrlRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.GenerateMobileSdkReleaseUrlResponse.ReadOnly
    ] = asyncRequestResponse[
      GenerateMobileSdkReleaseUrlRequest,
      GenerateMobileSdkReleaseUrlResponse
    ]("generateMobileSdkReleaseUrl", api.generateMobileSdkReleaseUrl)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.GenerateMobileSdkReleaseUrlResponse.wrap)
      .provideEnvironment(r)
    def listRuleGroups(
        request: zio.aws.wafv2.model.ListRuleGroupsRequest
    ): IO[AwsError, zio.aws.wafv2.model.ListRuleGroupsResponse.ReadOnly] =
      asyncRequestResponse[ListRuleGroupsRequest, ListRuleGroupsResponse](
        "listRuleGroups",
        api.listRuleGroups
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.ListRuleGroupsResponse.wrap)
        .provideEnvironment(r)
    def deleteRegexPatternSet(
        request: zio.aws.wafv2.model.DeleteRegexPatternSetRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.DeleteRegexPatternSetResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteRegexPatternSetRequest,
      DeleteRegexPatternSetResponse
    ]("deleteRegexPatternSet", api.deleteRegexPatternSet)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.DeleteRegexPatternSetResponse.wrap)
      .provideEnvironment(r)
    def disassociateWebACL(
        request: zio.aws.wafv2.model.DisassociateWebAclRequest
    ): IO[AwsError, zio.aws.wafv2.model.DisassociateWebAclResponse.ReadOnly] =
      asyncRequestResponse[
        DisassociateWebAclRequest,
        DisassociateWebAclResponse
      ]("disassociateWebACL", api.disassociateWebACL)(request.buildAwsValue())
        .map(zio.aws.wafv2.model.DisassociateWebAclResponse.wrap)
        .provideEnvironment(r)
    def listResourcesForWebACL(
        request: zio.aws.wafv2.model.ListResourcesForWebAclRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.ListResourcesForWebAclResponse.ReadOnly
    ] = asyncRequestResponse[
      ListResourcesForWebAclRequest,
      ListResourcesForWebAclResponse
    ]("listResourcesForWebACL", api.listResourcesForWebACL)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.ListResourcesForWebAclResponse.wrap)
      .provideEnvironment(r)
    def createIPSet(
        request: zio.aws.wafv2.model.CreateIpSetRequest
    ): IO[AwsError, zio.aws.wafv2.model.CreateIpSetResponse.ReadOnly] =
      asyncRequestResponse[CreateIpSetRequest, CreateIpSetResponse](
        "createIPSet",
        api.createIPSet
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.CreateIpSetResponse.wrap)
        .provideEnvironment(r)
    def getWebACLForResource(
        request: zio.aws.wafv2.model.GetWebAclForResourceRequest
    ): IO[AwsError, zio.aws.wafv2.model.GetWebAclForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        GetWebAclForResourceRequest,
        GetWebAclForResourceResponse
      ]("getWebACLForResource", api.getWebACLForResource)(
        request.buildAwsValue()
      ).map(zio.aws.wafv2.model.GetWebAclForResourceResponse.wrap)
        .provideEnvironment(r)
    def listRegexPatternSets(
        request: zio.aws.wafv2.model.ListRegexPatternSetsRequest
    ): IO[AwsError, zio.aws.wafv2.model.ListRegexPatternSetsResponse.ReadOnly] =
      asyncRequestResponse[
        ListRegexPatternSetsRequest,
        ListRegexPatternSetsResponse
      ]("listRegexPatternSets", api.listRegexPatternSets)(
        request.buildAwsValue()
      ).map(zio.aws.wafv2.model.ListRegexPatternSetsResponse.wrap)
        .provideEnvironment(r)
    def updateIPSet(
        request: zio.aws.wafv2.model.UpdateIpSetRequest
    ): IO[AwsError, zio.aws.wafv2.model.UpdateIpSetResponse.ReadOnly] =
      asyncRequestResponse[UpdateIpSetRequest, UpdateIpSetResponse](
        "updateIPSet",
        api.updateIPSet
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.UpdateIpSetResponse.wrap)
        .provideEnvironment(r)
    def updateManagedRuleSetVersionExpiryDate(
        request: zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateManagedRuleSetVersionExpiryDateRequest,
      UpdateManagedRuleSetVersionExpiryDateResponse
    ](
      "updateManagedRuleSetVersionExpiryDate",
      api.updateManagedRuleSetVersionExpiryDate
    )(request.buildAwsValue())
      .map(
        zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse.wrap
      )
      .provideEnvironment(r)
    def getManagedRuleSet(
        request: zio.aws.wafv2.model.GetManagedRuleSetRequest
    ): IO[AwsError, zio.aws.wafv2.model.GetManagedRuleSetResponse.ReadOnly] =
      asyncRequestResponse[GetManagedRuleSetRequest, GetManagedRuleSetResponse](
        "getManagedRuleSet",
        api.getManagedRuleSet
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.GetManagedRuleSetResponse.wrap)
        .provideEnvironment(r)
    def listAvailableManagedRuleGroups(
        request: zio.aws.wafv2.model.ListAvailableManagedRuleGroupsRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.ListAvailableManagedRuleGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAvailableManagedRuleGroupsRequest,
      ListAvailableManagedRuleGroupsResponse
    ]("listAvailableManagedRuleGroups", api.listAvailableManagedRuleGroups)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.ListAvailableManagedRuleGroupsResponse.wrap)
      .provideEnvironment(r)
    def checkCapacity(
        request: zio.aws.wafv2.model.CheckCapacityRequest
    ): IO[AwsError, zio.aws.wafv2.model.CheckCapacityResponse.ReadOnly] =
      asyncRequestResponse[CheckCapacityRequest, CheckCapacityResponse](
        "checkCapacity",
        api.checkCapacity
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.CheckCapacityResponse.wrap)
        .provideEnvironment(r)
    def putManagedRuleSetVersions(
        request: zio.aws.wafv2.model.PutManagedRuleSetVersionsRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.PutManagedRuleSetVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutManagedRuleSetVersionsRequest,
      PutManagedRuleSetVersionsResponse
    ]("putManagedRuleSetVersions", api.putManagedRuleSetVersions)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.PutManagedRuleSetVersionsResponse.wrap)
      .provideEnvironment(r)
    def associateWebACL(
        request: zio.aws.wafv2.model.AssociateWebAclRequest
    ): IO[AwsError, zio.aws.wafv2.model.AssociateWebAclResponse.ReadOnly] =
      asyncRequestResponse[AssociateWebAclRequest, AssociateWebAclResponse](
        "associateWebACL",
        api.associateWebACL
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.AssociateWebAclResponse.wrap)
        .provideEnvironment(r)
    def getRegexPatternSet(
        request: zio.aws.wafv2.model.GetRegexPatternSetRequest
    ): IO[AwsError, zio.aws.wafv2.model.GetRegexPatternSetResponse.ReadOnly] =
      asyncRequestResponse[
        GetRegexPatternSetRequest,
        GetRegexPatternSetResponse
      ]("getRegexPatternSet", api.getRegexPatternSet)(request.buildAwsValue())
        .map(zio.aws.wafv2.model.GetRegexPatternSetResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.wafv2.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.wafv2.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def putLoggingConfiguration(
        request: zio.aws.wafv2.model.PutLoggingConfigurationRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      PutLoggingConfigurationRequest,
      PutLoggingConfigurationResponse
    ]("putLoggingConfiguration", api.putLoggingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.PutLoggingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeManagedRuleGroup(
        request: zio.aws.wafv2.model.DescribeManagedRuleGroupRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeManagedRuleGroupRequest,
      DescribeManagedRuleGroupResponse
    ]("describeManagedRuleGroup", api.describeManagedRuleGroup)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteWebACL(
        request: zio.aws.wafv2.model.DeleteWebAclRequest
    ): IO[AwsError, zio.aws.wafv2.model.DeleteWebAclResponse.ReadOnly] =
      asyncRequestResponse[DeleteWebAclRequest, DeleteWebAclResponse](
        "deleteWebACL",
        api.deleteWebACL
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.DeleteWebAclResponse.wrap)
        .provideEnvironment(r)
    def listAvailableManagedRuleGroupVersions(
        request: zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAvailableManagedRuleGroupVersionsRequest,
      ListAvailableManagedRuleGroupVersionsResponse
    ](
      "listAvailableManagedRuleGroupVersions",
      api.listAvailableManagedRuleGroupVersions
    )(request.buildAwsValue())
      .map(
        zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse.wrap
      )
      .provideEnvironment(r)
    def createRegexPatternSet(
        request: zio.aws.wafv2.model.CreateRegexPatternSetRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.CreateRegexPatternSetResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateRegexPatternSetRequest,
      CreateRegexPatternSetResponse
    ]("createRegexPatternSet", api.createRegexPatternSet)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.CreateRegexPatternSetResponse.wrap)
      .provideEnvironment(r)
    def listWebACLs(
        request: zio.aws.wafv2.model.ListWebAcLsRequest
    ): IO[AwsError, zio.aws.wafv2.model.ListWebAcLsResponse.ReadOnly] =
      asyncRequestResponse[ListWebAcLsRequest, ListWebAcLsResponse](
        "listWebACLs",
        api.listWebACLs
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.ListWebAcLsResponse.wrap)
        .provideEnvironment(r)
    def putPermissionPolicy(
        request: zio.aws.wafv2.model.PutPermissionPolicyRequest
    ): IO[AwsError, zio.aws.wafv2.model.PutPermissionPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        PutPermissionPolicyRequest,
        PutPermissionPolicyResponse
      ]("putPermissionPolicy", api.putPermissionPolicy)(request.buildAwsValue())
        .map(zio.aws.wafv2.model.PutPermissionPolicyResponse.wrap)
        .provideEnvironment(r)
    def getLoggingConfiguration(
        request: zio.aws.wafv2.model.GetLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.GetLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetLoggingConfigurationRequest,
      GetLoggingConfigurationResponse
    ]("getLoggingConfiguration", api.getLoggingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.GetLoggingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.wafv2.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.wafv2.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.wafv2.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteFirewallManagerRuleGroups(
        request: zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteFirewallManagerRuleGroupsRequest,
      DeleteFirewallManagerRuleGroupsResponse
    ]("deleteFirewallManagerRuleGroups", api.deleteFirewallManagerRuleGroups)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.wafv2.model.TagResourceRequest
    ): IO[AwsError, zio.aws.wafv2.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listLoggingConfigurations(
        request: zio.aws.wafv2.model.ListLoggingConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.ListLoggingConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListLoggingConfigurationsRequest,
      ListLoggingConfigurationsResponse
    ]("listLoggingConfigurations", api.listLoggingConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.ListLoggingConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def deleteLoggingConfiguration(
        request: zio.aws.wafv2.model.DeleteLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.DeleteLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteLoggingConfigurationRequest,
      DeleteLoggingConfigurationResponse
    ]("deleteLoggingConfiguration", api.deleteLoggingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.DeleteLoggingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listMobileSdkReleases(
        request: zio.aws.wafv2.model.ListMobileSdkReleasesRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.ListMobileSdkReleasesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListMobileSdkReleasesRequest,
      ListMobileSdkReleasesResponse
    ]("listMobileSdkReleases", api.listMobileSdkReleases)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.ListMobileSdkReleasesResponse.wrap)
      .provideEnvironment(r)
    def listManagedRuleSets(
        request: zio.aws.wafv2.model.ListManagedRuleSetsRequest
    ): IO[AwsError, zio.aws.wafv2.model.ListManagedRuleSetsResponse.ReadOnly] =
      asyncRequestResponse[
        ListManagedRuleSetsRequest,
        ListManagedRuleSetsResponse
      ]("listManagedRuleSets", api.listManagedRuleSets)(request.buildAwsValue())
        .map(zio.aws.wafv2.model.ListManagedRuleSetsResponse.wrap)
        .provideEnvironment(r)
    def updateRuleGroup(
        request: zio.aws.wafv2.model.UpdateRuleGroupRequest
    ): IO[AwsError, zio.aws.wafv2.model.UpdateRuleGroupResponse.ReadOnly] =
      asyncRequestResponse[UpdateRuleGroupRequest, UpdateRuleGroupResponse](
        "updateRuleGroup",
        api.updateRuleGroup
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.UpdateRuleGroupResponse.wrap)
        .provideEnvironment(r)
    def updateRegexPatternSet(
        request: zio.aws.wafv2.model.UpdateRegexPatternSetRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.UpdateRegexPatternSetResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateRegexPatternSetRequest,
      UpdateRegexPatternSetResponse
    ]("updateRegexPatternSet", api.updateRegexPatternSet)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.UpdateRegexPatternSetResponse.wrap)
      .provideEnvironment(r)
    def getRateBasedStatementManagedKeys(
        request: zio.aws.wafv2.model.GetRateBasedStatementManagedKeysRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.GetRateBasedStatementManagedKeysResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRateBasedStatementManagedKeysRequest,
      GetRateBasedStatementManagedKeysResponse
    ]("getRateBasedStatementManagedKeys", api.getRateBasedStatementManagedKeys)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.GetRateBasedStatementManagedKeysResponse.wrap)
      .provideEnvironment(r)
    def createWebACL(
        request: zio.aws.wafv2.model.CreateWebAclRequest
    ): IO[AwsError, zio.aws.wafv2.model.CreateWebAclResponse.ReadOnly] =
      asyncRequestResponse[CreateWebAclRequest, CreateWebAclResponse](
        "createWebACL",
        api.createWebACL
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.CreateWebAclResponse.wrap)
        .provideEnvironment(r)
    def getPermissionPolicy(
        request: zio.aws.wafv2.model.GetPermissionPolicyRequest
    ): IO[AwsError, zio.aws.wafv2.model.GetPermissionPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        GetPermissionPolicyRequest,
        GetPermissionPolicyResponse
      ]("getPermissionPolicy", api.getPermissionPolicy)(request.buildAwsValue())
        .map(zio.aws.wafv2.model.GetPermissionPolicyResponse.wrap)
        .provideEnvironment(r)
    def updateWebACL(
        request: zio.aws.wafv2.model.UpdateWebAclRequest
    ): IO[AwsError, zio.aws.wafv2.model.UpdateWebAclResponse.ReadOnly] =
      asyncRequestResponse[UpdateWebAclRequest, UpdateWebAclResponse](
        "updateWebACL",
        api.updateWebACL
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.UpdateWebAclResponse.wrap)
        .provideEnvironment(r)
    def deleteRuleGroup(
        request: zio.aws.wafv2.model.DeleteRuleGroupRequest
    ): IO[AwsError, zio.aws.wafv2.model.DeleteRuleGroupResponse.ReadOnly] =
      asyncRequestResponse[DeleteRuleGroupRequest, DeleteRuleGroupResponse](
        "deleteRuleGroup",
        api.deleteRuleGroup
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.DeleteRuleGroupResponse.wrap)
        .provideEnvironment(r)
    def listIPSets(
        request: zio.aws.wafv2.model.ListIpSetsRequest
    ): IO[AwsError, zio.aws.wafv2.model.ListIpSetsResponse.ReadOnly] =
      asyncRequestResponse[ListIpSetsRequest, ListIpSetsResponse](
        "listIPSets",
        api.listIPSets
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.ListIpSetsResponse.wrap)
        .provideEnvironment(r)
    def getSampledRequests(
        request: zio.aws.wafv2.model.GetSampledRequestsRequest
    ): IO[AwsError, zio.aws.wafv2.model.GetSampledRequestsResponse.ReadOnly] =
      asyncRequestResponse[
        GetSampledRequestsRequest,
        GetSampledRequestsResponse
      ]("getSampledRequests", api.getSampledRequests)(request.buildAwsValue())
        .map(zio.aws.wafv2.model.GetSampledRequestsResponse.wrap)
        .provideEnvironment(r)
    def deleteIPSet(
        request: zio.aws.wafv2.model.DeleteIpSetRequest
    ): IO[AwsError, zio.aws.wafv2.model.DeleteIpSetResponse.ReadOnly] =
      asyncRequestResponse[DeleteIpSetRequest, DeleteIpSetResponse](
        "deleteIPSet",
        api.deleteIPSet
      )(request.buildAwsValue())
        .map(zio.aws.wafv2.model.DeleteIpSetResponse.wrap)
        .provideEnvironment(r)
    def deletePermissionPolicy(
        request: zio.aws.wafv2.model.DeletePermissionPolicyRequest
    ): IO[
      AwsError,
      zio.aws.wafv2.model.DeletePermissionPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeletePermissionPolicyRequest,
      DeletePermissionPolicyResponse
    ]("deletePermissionPolicy", api.deletePermissionPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.wafv2.model.DeletePermissionPolicyResponse.wrap)
      .provideEnvironment(r)
  }
  def getRuleGroup(request: zio.aws.wafv2.model.GetRuleGroupRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.GetRuleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRuleGroup(request))
  def getWebACL(request: zio.aws.wafv2.model.GetWebAclRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.GetWebAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWebACL(request))
  def getMobileSdkRelease(
      request: zio.aws.wafv2.model.GetMobileSdkReleaseRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.GetMobileSdkReleaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMobileSdkRelease(request))
  def getIPSet(request: zio.aws.wafv2.model.GetIpSetRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.GetIpSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIPSet(request))
  def createRuleGroup(request: zio.aws.wafv2.model.CreateRuleGroupRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.CreateRuleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRuleGroup(request))
  def generateMobileSdkReleaseUrl(
      request: zio.aws.wafv2.model.GenerateMobileSdkReleaseUrlRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.GenerateMobileSdkReleaseUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateMobileSdkReleaseUrl(request))
  def listRuleGroups(request: zio.aws.wafv2.model.ListRuleGroupsRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.ListRuleGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRuleGroups(request))
  def deleteRegexPatternSet(
      request: zio.aws.wafv2.model.DeleteRegexPatternSetRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.DeleteRegexPatternSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRegexPatternSet(request))
  def disassociateWebACL(
      request: zio.aws.wafv2.model.DisassociateWebAclRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.DisassociateWebAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateWebACL(request))
  def listResourcesForWebACL(
      request: zio.aws.wafv2.model.ListResourcesForWebAclRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.ListResourcesForWebAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResourcesForWebACL(request))
  def createIPSet(request: zio.aws.wafv2.model.CreateIpSetRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.CreateIpSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIPSet(request))
  def getWebACLForResource(
      request: zio.aws.wafv2.model.GetWebAclForResourceRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.GetWebAclForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWebACLForResource(request))
  def listRegexPatternSets(
      request: zio.aws.wafv2.model.ListRegexPatternSetsRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.ListRegexPatternSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRegexPatternSets(request))
  def updateIPSet(request: zio.aws.wafv2.model.UpdateIpSetRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.UpdateIpSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateIPSet(request))
  def updateManagedRuleSetVersionExpiryDate(
      request: zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateManagedRuleSetVersionExpiryDate(request))
  def getManagedRuleSet(
      request: zio.aws.wafv2.model.GetManagedRuleSetRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.GetManagedRuleSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getManagedRuleSet(request))
  def listAvailableManagedRuleGroups(
      request: zio.aws.wafv2.model.ListAvailableManagedRuleGroupsRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.ListAvailableManagedRuleGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAvailableManagedRuleGroups(request))
  def checkCapacity(request: zio.aws.wafv2.model.CheckCapacityRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.CheckCapacityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.checkCapacity(request))
  def putManagedRuleSetVersions(
      request: zio.aws.wafv2.model.PutManagedRuleSetVersionsRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.PutManagedRuleSetVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putManagedRuleSetVersions(request))
  def associateWebACL(request: zio.aws.wafv2.model.AssociateWebAclRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.AssociateWebAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateWebACL(request))
  def getRegexPatternSet(
      request: zio.aws.wafv2.model.GetRegexPatternSetRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.GetRegexPatternSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRegexPatternSet(request))
  def untagResource(request: zio.aws.wafv2.model.UntagResourceRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def putLoggingConfiguration(
      request: zio.aws.wafv2.model.PutLoggingConfigurationRequest
  ): ZIO[zio.aws.wafv2.Wafv2, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.putLoggingConfiguration(request))
  def describeManagedRuleGroup(
      request: zio.aws.wafv2.model.DescribeManagedRuleGroupRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeManagedRuleGroup(request))
  def deleteWebACL(request: zio.aws.wafv2.model.DeleteWebAclRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.DeleteWebAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWebACL(request))
  def listAvailableManagedRuleGroupVersions(
      request: zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAvailableManagedRuleGroupVersions(request))
  def createRegexPatternSet(
      request: zio.aws.wafv2.model.CreateRegexPatternSetRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.CreateRegexPatternSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRegexPatternSet(request))
  def listWebACLs(request: zio.aws.wafv2.model.ListWebAcLsRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.ListWebAcLsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWebACLs(request))
  def putPermissionPolicy(
      request: zio.aws.wafv2.model.PutPermissionPolicyRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.PutPermissionPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putPermissionPolicy(request))
  def getLoggingConfiguration(
      request: zio.aws.wafv2.model.GetLoggingConfigurationRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.GetLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLoggingConfiguration(request))
  def listTagsForResource(
      request: zio.aws.wafv2.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteFirewallManagerRuleGroups(
      request: zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFirewallManagerRuleGroups(request))
  def tagResource(request: zio.aws.wafv2.model.TagResourceRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listLoggingConfigurations(
      request: zio.aws.wafv2.model.ListLoggingConfigurationsRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.ListLoggingConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLoggingConfigurations(request))
  def deleteLoggingConfiguration(
      request: zio.aws.wafv2.model.DeleteLoggingConfigurationRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.DeleteLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLoggingConfiguration(request))
  def listMobileSdkReleases(
      request: zio.aws.wafv2.model.ListMobileSdkReleasesRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.ListMobileSdkReleasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMobileSdkReleases(request))
  def listManagedRuleSets(
      request: zio.aws.wafv2.model.ListManagedRuleSetsRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.ListManagedRuleSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listManagedRuleSets(request))
  def updateRuleGroup(request: zio.aws.wafv2.model.UpdateRuleGroupRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.UpdateRuleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRuleGroup(request))
  def updateRegexPatternSet(
      request: zio.aws.wafv2.model.UpdateRegexPatternSetRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.UpdateRegexPatternSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRegexPatternSet(request))
  def getRateBasedStatementManagedKeys(
      request: zio.aws.wafv2.model.GetRateBasedStatementManagedKeysRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.GetRateBasedStatementManagedKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRateBasedStatementManagedKeys(request))
  def createWebACL(request: zio.aws.wafv2.model.CreateWebAclRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.CreateWebAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWebACL(request))
  def getPermissionPolicy(
      request: zio.aws.wafv2.model.GetPermissionPolicyRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.GetPermissionPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPermissionPolicy(request))
  def updateWebACL(request: zio.aws.wafv2.model.UpdateWebAclRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.UpdateWebAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWebACL(request))
  def deleteRuleGroup(request: zio.aws.wafv2.model.DeleteRuleGroupRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.DeleteRuleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRuleGroup(request))
  def listIPSets(request: zio.aws.wafv2.model.ListIpSetsRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.ListIpSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIPSets(request))
  def getSampledRequests(
      request: zio.aws.wafv2.model.GetSampledRequestsRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.GetSampledRequestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSampledRequests(request))
  def deleteIPSet(request: zio.aws.wafv2.model.DeleteIpSetRequest): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.DeleteIpSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteIPSet(request))
  def deletePermissionPolicy(
      request: zio.aws.wafv2.model.DeletePermissionPolicyRequest
  ): ZIO[
    zio.aws.wafv2.Wafv2,
    AwsError,
    zio.aws.wafv2.model.DeletePermissionPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePermissionPolicy(request))
}
