package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.wafv2.model.primitives.{
  LockToken,
  VersionKeyString,
  Timestamp,
  EntityId,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class UpdateManagedRuleSetVersionExpiryDateRequest(
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    id: EntityId,
    lockToken: LockToken,
    versionToExpire: VersionKeyString,
    expiryTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest = {
    import UpdateManagedRuleSetVersionExpiryDateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .id(EntityId.unwrap(id): java.lang.String)
      .lockToken(LockToken.unwrap(lockToken): java.lang.String)
      .versionToExpire(
        VersionKeyString.unwrap(versionToExpire): java.lang.String
      )
      .expiryTimestamp(Timestamp.unwrap(expiryTimestamp): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest.ReadOnly =
    zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest
      .wrap(buildAwsValue())
}
object UpdateManagedRuleSetVersionExpiryDateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest =
      zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest(
        name,
        scope,
        id,
        lockToken,
        versionToExpire,
        expiryTimestamp
      )
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def id: EntityId
    def lockToken: LockToken
    def versionToExpire: VersionKeyString
    def expiryTimestamp: Timestamp
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(id)
    def getLockToken: ZIO[Any, Nothing, LockToken] = ZIO.succeed(lockToken)
    def getVersionToExpire: ZIO[Any, Nothing, VersionKeyString] =
      ZIO.succeed(versionToExpire)
    def getExpiryTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(expiryTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest
  ) extends zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val id: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.id())
    override val lockToken: LockToken =
      zio.aws.wafv2.model.primitives.LockToken(impl.lockToken())
    override val versionToExpire: VersionKeyString =
      zio.aws.wafv2.model.primitives.VersionKeyString(impl.versionToExpire())
    override val expiryTimestamp: Timestamp =
      zio.aws.wafv2.model.primitives.Timestamp(impl.expiryTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest
  ): zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest.ReadOnly =
    new Wrapper(impl)
}
