package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class TagInfoForResource(
    resourceARN: Option[ResourceArn] = None,
    tagList: Option[Iterable[zio.aws.wafv2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.TagInfoForResource = {
    import TagInfoForResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.TagInfoForResource
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.TagInfoForResource.ReadOnly =
    zio.aws.wafv2.model.TagInfoForResource.wrap(buildAwsValue())
}
object TagInfoForResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.TagInfoForResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.TagInfoForResource =
      zio.aws.wafv2.model.TagInfoForResource(
        resourceARN.map(value => value),
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceARN: Option[ResourceArn]
    def tagList: Option[List[zio.aws.wafv2.model.Tag.ReadOnly]]
    def getResourceARN: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.TagInfoForResource
  ) extends zio.aws.wafv2.model.TagInfoForResource.ReadOnly {
    override val resourceARN: Option[ResourceArn] = scala
      .Option(impl.resourceARN())
      .map(value => zio.aws.wafv2.model.primitives.ResourceArn(value))
    override val tagList: Option[List[zio.aws.wafv2.model.Tag.ReadOnly]] = scala
      .Option(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.TagInfoForResource
  ): zio.aws.wafv2.model.TagInfoForResource.ReadOnly = new Wrapper(impl)
}
