package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.IPAddress
import scala.jdk.CollectionConverters._
final case class RateBasedStatementManagedKeysIPSet(
    ipAddressVersion: Option[zio.aws.wafv2.model.IPAddressVersion] = None,
    addresses: Option[Iterable[IPAddress]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RateBasedStatementManagedKeysIPSet = {
    import RateBasedStatementManagedKeysIPSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RateBasedStatementManagedKeysIPSet
      .builder()
      .optionallyWith(ipAddressVersion.map(value => value.unwrap))(
        _.ipAddressVersion
      )
      .optionallyWith(
        addresses.map(value =>
          value.map { item =>
            IPAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addresses)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet.ReadOnly =
    zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet.wrap(buildAwsValue())
}
object RateBasedStatementManagedKeysIPSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RateBasedStatementManagedKeysIPSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet =
      zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet(
        ipAddressVersion.map(value => value),
        addresses.map(value => value)
      )
    def ipAddressVersion: Option[zio.aws.wafv2.model.IPAddressVersion]
    def addresses: Option[List[IPAddress]]
    def getIpAddressVersion
        : ZIO[Any, AwsError, zio.aws.wafv2.model.IPAddressVersion] =
      AwsError.unwrapOptionField("ipAddressVersion", ipAddressVersion)
    def getAddresses: ZIO[Any, AwsError, List[IPAddress]] =
      AwsError.unwrapOptionField("addresses", addresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RateBasedStatementManagedKeysIPSet
  ) extends zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet.ReadOnly {
    override val ipAddressVersion
        : Option[zio.aws.wafv2.model.IPAddressVersion] = scala
      .Option(impl.ipAddressVersion())
      .map(value => zio.aws.wafv2.model.IPAddressVersion.wrap(value))
    override val addresses: Option[List[IPAddress]] = scala
      .Option(impl.addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.primitives.IPAddress(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RateBasedStatementManagedKeysIPSet
  ): zio.aws.wafv2.model.RateBasedStatementManagedKeysIPSet.ReadOnly =
    new Wrapper(impl)
}
