package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{
  EntityDescription,
  EntityName,
  VendorName
}
import scala.jdk.CollectionConverters._
final case class ManagedRuleGroupSummary(
    vendorName: Option[VendorName] = None,
    name: Option[EntityName] = None,
    description: Option[EntityDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupSummary = {
    import ManagedRuleGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupSummary
      .builder()
      .optionallyWith(
        vendorName.map(value => VendorName.unwrap(value): java.lang.String)
      )(_.vendorName)
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ManagedRuleGroupSummary.ReadOnly =
    zio.aws.wafv2.model.ManagedRuleGroupSummary.wrap(buildAwsValue())
}
object ManagedRuleGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ManagedRuleGroupSummary =
      zio.aws.wafv2.model.ManagedRuleGroupSummary(
        vendorName.map(value => value),
        name.map(value => value),
        description.map(value => value)
      )
    def vendorName: Option[VendorName]
    def name: Option[EntityName]
    def description: Option[EntityDescription]
    def getVendorName: ZIO[Any, AwsError, VendorName] =
      AwsError.unwrapOptionField("vendorName", vendorName)
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupSummary
  ) extends zio.aws.wafv2.model.ManagedRuleGroupSummary.ReadOnly {
    override val vendorName: Option[VendorName] = scala
      .Option(impl.vendorName())
      .map(value => zio.aws.wafv2.model.primitives.VendorName(value))
    override val name: Option[EntityName] = scala
      .Option(impl.name())
      .map(value => zio.aws.wafv2.model.primitives.EntityName(value))
    override val description: Option[EntityDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupSummary
  ): zio.aws.wafv2.model.ManagedRuleGroupSummary.ReadOnly = new Wrapper(impl)
}
