package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListManagedRuleSetsResponse(
    nextMarker: Option[NextMarker] = None,
    managedRuleSets: Option[
      Iterable[zio.aws.wafv2.model.ManagedRuleSetSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsResponse = {
    import ListManagedRuleSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        managedRuleSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedRuleSets)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListManagedRuleSetsResponse.ReadOnly =
    zio.aws.wafv2.model.ListManagedRuleSetsResponse.wrap(buildAwsValue())
}
object ListManagedRuleSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListManagedRuleSetsResponse =
      zio.aws.wafv2.model.ListManagedRuleSetsResponse(
        nextMarker.map(value => value),
        managedRuleSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def managedRuleSets
        : Option[List[zio.aws.wafv2.model.ManagedRuleSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getManagedRuleSets: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.ManagedRuleSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("managedRuleSets", managedRuleSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsResponse
  ) extends zio.aws.wafv2.model.ListManagedRuleSetsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val managedRuleSets
        : Option[List[zio.aws.wafv2.model.ManagedRuleSetSummary.ReadOnly]] =
      scala
        .Option(impl.managedRuleSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.ManagedRuleSetSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsResponse
  ): zio.aws.wafv2.model.ListManagedRuleSetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
