package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.DownloadUrl
import scala.jdk.CollectionConverters._
final case class GenerateMobileSdkReleaseUrlResponse(
    url: Option[DownloadUrl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GenerateMobileSdkReleaseUrlResponse = {
    import GenerateMobileSdkReleaseUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GenerateMobileSdkReleaseUrlResponse
      .builder()
      .optionallyWith(
        url.map(value => DownloadUrl.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.GenerateMobileSdkReleaseUrlResponse.ReadOnly =
    zio.aws.wafv2.model.GenerateMobileSdkReleaseUrlResponse
      .wrap(buildAwsValue())
}
object GenerateMobileSdkReleaseUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GenerateMobileSdkReleaseUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GenerateMobileSdkReleaseUrlResponse =
      zio.aws.wafv2.model
        .GenerateMobileSdkReleaseUrlResponse(url.map(value => value))
    def url: Option[DownloadUrl]
    def getUrl: ZIO[Any, AwsError, DownloadUrl] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GenerateMobileSdkReleaseUrlResponse
  ) extends zio.aws.wafv2.model.GenerateMobileSdkReleaseUrlResponse.ReadOnly {
    override val url: Option[DownloadUrl] = scala
      .Option(impl.url())
      .map(value => zio.aws.wafv2.model.primitives.DownloadUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GenerateMobileSdkReleaseUrlResponse
  ): zio.aws.wafv2.model.GenerateMobileSdkReleaseUrlResponse.ReadOnly =
    new Wrapper(impl)
}
