package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.wafv2.model.primitives.{Timestamp, VersionKeyString}
import scala.jdk.CollectionConverters._
final case class ReleaseSummary(
    releaseVersion: Option[VersionKeyString] = None,
    timestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ReleaseSummary = {
    import ReleaseSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ReleaseSummary
      .builder()
      .optionallyWith(
        releaseVersion.map(value =>
          VersionKeyString.unwrap(value): java.lang.String
        )
      )(_.releaseVersion)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ReleaseSummary.ReadOnly =
    zio.aws.wafv2.model.ReleaseSummary.wrap(buildAwsValue())
}
object ReleaseSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ReleaseSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ReleaseSummary =
      zio.aws.wafv2.model.ReleaseSummary(
        releaseVersion.map(value => value),
        timestamp.map(value => value)
      )
    def releaseVersion: Option[VersionKeyString]
    def timestamp: Option[Timestamp]
    def getReleaseVersion: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("releaseVersion", releaseVersion)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ReleaseSummary
  ) extends zio.aws.wafv2.model.ReleaseSummary.ReadOnly {
    override val releaseVersion: Option[VersionKeyString] = scala
      .Option(impl.releaseVersion())
      .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.wafv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ReleaseSummary
  ): zio.aws.wafv2.model.ReleaseSummary.ReadOnly = new Wrapper(impl)
}
